/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSink;
import org.xlightweb.FutureResponseHandler;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IFutureResponse;
import org.xlightweb.IHeader;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.ProtocolException;
import org.xlightweb.client.FutureContinueResponseHandler;
import org.xlightweb.client.IHttpClientEndpoint;
import org.xlightweb.client.SessionManager;
import org.xlightweb.client.TransactionMonitor;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnectExceptionHandler;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnection;
import org.xsocket.connection.NonBlockingConnectionPool;

public final class HttpClientConnection
extends AbstractHttpConnection
implements IHttpClientEndpoint {
    private static final Logger LOG = Logger.getLogger(HttpClientConnection.class.getName());
    private static String implementationVersion;
    private static final DoNothingMessageHandler DO_NOTHING_HANDLER;
    static final String TIMEOUT_100_CONTINUE_RESPONSE = "org.xlightweb.HttpClientConnection.100-continueTimeout";
    static final String IS_AUTOCONTINUE_DEACTIVATED = "org.xlightweb.HttpClientConnection.isAutocontinueDeactivated";
    private static boolean IS_CLOSE_CONNECTION_ON_5XX_RESPONSE;
    private boolean isAutocloseAfterResponse = false;
    private final AtomicBoolean isDisconnected = new AtomicBoolean(false);
    private final ArrayList<MessageHeaderHandler> handlersWaitingForResponseHeader = new ArrayList();
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 30000L;
    private long responseTimeoutMillis = Long.MAX_VALUE;
    private WatchDogTask watchDogTask;
    private static final int CONTINUE_TIMEOUT_MILLIS;
    private TransactionMonitor transactionMonitor;

    static {
        DO_NOTHING_HANDLER = new DoNothingMessageHandler();
        IS_CLOSE_CONNECTION_ON_5XX_RESPONSE = Boolean.parseBoolean(System.getProperty("org.xlightweb.client.closeConnectionOn5xxResponse", "true"));
        CONTINUE_TIMEOUT_MILLIS = Integer.parseInt(System.getProperty("org.xlightweb.client.response.continueTimeoutMillis", "3000"));
    }

    public HttpClientConnection(String host, int port) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(new InetSocketAddress(host, port), null), null);
    }

    public HttpClientConnection(String host, int port, Executor workerpool) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(new InetSocketAddress(host, port), workerpool), null);
    }

    public HttpClientConnection(InetSocketAddress address) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(address, null), null);
    }

    public HttpClientConnection(InetSocketAddress address, Executor workerpool) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(address, workerpool), null);
    }

    private static INonBlockingConnection newNonBlockingConnection(InetSocketAddress address, Executor workerpool) throws ConnectException {
        try {
            if (workerpool == null) {
                return new NonBlockingConnection(address);
            }
            return new NonBlockingConnection(address.getHostName(), address.getPort(), null, workerpool);
        }
        catch (IOException ioe) {
            throw new ConnectException(ioe.toString());
        }
    }

    protected static boolean isComplete(NonBlockingBodyDataSource body) {
        return AbstractHttpConnection.isComplete(body);
    }

    protected static boolean isNetworkendpoint(NonBlockingBodyDataSource dataSource) {
        return AbstractHttpConnection.isNetworkendpoint(dataSource);
    }

    protected static void addConnectionAttribute(IHttpResponseHeader header, IHttpConnection con) {
        AbstractHttpConnection.addConnectionAttribute(header, con);
    }

    protected static boolean isSupports100Contine(IHttpResponseHandler handler) {
        return AbstractHttpConnection.isSupports100Contine(handler);
    }

    protected static void forward(NonBlockingBodyDataSource dataSource, BodyDataSink dataSink) throws IOException {
        AbstractHttpConnection.forward(dataSource, dataSink);
    }

    protected static int getDataReceived(NonBlockingBodyDataSource dataSource) {
        return AbstractHttpConnection.getDataReceived(dataSource);
    }

    protected static BodyDataSink newInMemoryBodyDataSink(String id, IHttpMessageHeader header) throws IOException {
        return AbstractHttpConnection.newInMemoryBodyDataSink(id, header);
    }

    protected static IHeader getReceivedHeader(ProtocolException pe) {
        return AbstractHttpConnection.getReceviedHeader(pe);
    }

    protected static NonBlockingBodyDataSource getDataSourceOfInMemoryBodyDataSink(BodyDataSink dataSink) {
        return AbstractHttpConnection.getDataSourceOfInMemoryBodyDataSink(dataSink);
    }

    protected static void setDataHandlerSilence(NonBlockingBodyDataSource dataSource, IBodyDataHandler dataHandler) {
        AbstractHttpConnection.setDataHandlerSilence(dataSource, dataHandler);
    }

    protected static IBodyDataHandler getDataHandlerSilence(NonBlockingBodyDataSource dataSource) {
        return AbstractHttpConnection.getDataHandlerSilence(dataSource);
    }

    protected static int availableSilence(NonBlockingBodyDataSource dataSource) throws IOException {
        return AbstractHttpConnection.availableSilence(dataSource);
    }

    protected static ByteBuffer[] readByteBufferByLengthSilence(NonBlockingBodyDataSource dataSource, int length) throws IOException {
        return AbstractHttpConnection.readByteBufferByLengthSilence(dataSource, length);
    }

    public HttpClientConnection(INonBlockingConnection connection) throws IOException {
        this(connection, null);
        this.init();
    }

    public HttpClientConnection(String host, int port, IHttpConnectionHandler connectionHandler) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(new InetSocketAddress(host, port), null), connectionHandler);
    }

    public HttpClientConnection(String host, int port, Executor workerpool, IHttpConnectionHandler connectionHandler) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(new InetSocketAddress(host, port), workerpool), connectionHandler);
    }

    private HttpClientConnection(INonBlockingConnection connection, IHttpConnectionHandler connectionHandler) throws IOException {
        super(connection, true);
        if (connectionHandler != null) {
            this.addConnectionHandler(connectionHandler);
        }
        this.init();
    }

    @Override
    public void close() throws IOException {
        if (this.getNumOpenTransactions() != 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] " + this.getNumOpenTransactions() + " open transaction(s). setting persistent to false");
            }
            this.setPersistent(false);
            if (!this.handlersWaitingForResponseHeader.isEmpty()) {
                if (LOG.isLoggable(Level.FINE)) {
                    for (MessageHeaderHandler headerHandler : this.handlersWaitingForResponseHeader) {
                        LOG.fine("[" + this.getId() + "] removing waiting measage header handler " + headerHandler);
                    }
                }
                this.handlersWaitingForResponseHeader.clear();
            }
        }
        super.close();
    }

    void setTransactionMonitor(TransactionMonitor transactionMonitor) {
        this.transactionMonitor = transactionMonitor;
    }

    @Override
    protected void onIdleTimeout() {
        for (MessageHeaderHandler messageHandler : this.getHandlersWaitingForResponseCopy()) {
            messageHandler.onException(new SocketTimeoutException("idle timeout " + DataConverter.toFormatedDuration(this.getIdleTimeoutMillis()) + " reached"));
        }
        this.handlersWaitingForResponseHeader.clear();
        super.onIdleTimeout();
    }

    @Override
    protected void onConnectionTimeout() {
        for (MessageHeaderHandler messageHandler : this.getHandlersWaitingForResponseCopy()) {
            messageHandler.onException(new SocketTimeoutException("connection timeout " + DataConverter.toFormatedDuration(this.getConnectionTimeoutMillis()) + " reached"));
        }
        this.handlersWaitingForResponseHeader.clear();
        super.onConnectionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageHeaderHandler> getHandlersWaitingForResponseCopy() {
        ArrayList<MessageHeaderHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            return (List)this.handlersWaitingForResponseHeader.clone();
        }
    }

    @Override
    protected void onDisconnect() {
        if (!this.isDisconnected.getAndSet(true)) {
            this.setPersistent(false);
            for (MessageHeaderHandler messageHandler : this.getHandlersWaitingForResponseCopy()) {
                ClosedChannelException cce = HttpClientConnection.newDetailedClosedChannelException("channel " + this.getId() + " is closed (by peer?) while receiving response data " + "(countMessagesSent=" + this.getCountMessagesSent() + ", countMessagesReceived=" + this.getCountMessagesReceived() + ", countReceivedBytes=" + this.getCountReceivedBytes() + ")");
                messageHandler.onException(cce);
            }
            this.handlersWaitingForResponseHeader.clear();
            this.transactionMonitor = null;
            if (this.watchDogTask != null) {
                this.watchDogTask.close();
            }
            this.watchDogTask = null;
            super.onDisconnect();
        }
    }

    protected static String generateErrorMessageHtml(int errorCode, String msg, String id) {
        return AbstractHttpConnection.generateErrorMessageHtml(errorCode, msg, id);
    }

    protected static void schedule(TimerTask task, long delay, long period) {
        AbstractHttpConnection.schedule(task, delay, period);
    }

    @Override
    public IHttpResponse call(IHttpRequest request) throws IOException, ConnectException, SocketTimeoutException {
        IFutureResponse futureResponse = this.send(request);
        try {
            return futureResponse.getResponse();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.toString());
        }
    }

    void setAutocloseAfterResponse(boolean isAutocloseAfterResponse) {
        this.isAutocloseAfterResponse = isAutocloseAfterResponse;
    }

    @Override
    protected void onMessageCompleteReceived(IHttpMessageHeader header) {
        int status = ((IHttpResponseHeader)header).getStatus();
        if (status >= 100 && status < 200) {
            this.setPersistent(false);
            return;
        }
        super.setNetworkBodyDataSinkIgnoreWriteError();
        super.onMessageCompleteReceived(header);
        if (!this.isPersistent()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] connection is not persistent. destroying it");
            }
            this.destroy();
        } else if (this.isAutocloseAfterResponse) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] closing connection");
            }
            this.closeQuitly();
        }
    }

    @Override
    public boolean isServerSide() {
        return false;
    }

    public void setResponseBodyDefaultEncoding(String defaultEncoding) {
        this.setBodyDefaultEncoding(defaultEncoding);
    }

    @Override
    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        if (this.responseTimeoutMillis != responseTimeoutMillis) {
            this.responseTimeoutMillis = responseTimeoutMillis;
            if (responseTimeoutMillis == Long.MAX_VALUE) {
                this.terminateWatchDogTask();
            } else {
                long watchdogPeriod = 100L;
                if (responseTimeoutMillis > 1000L) {
                    watchdogPeriod = responseTimeoutMillis / 10L;
                }
                if (watchdogPeriod > 30000L) {
                    watchdogPeriod = 30000L;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] response timeout to " + DataConverter.toFormatedDuration(responseTimeoutMillis) + ". Updating wachdog tas to check period " + watchdogPeriod + " millis");
                }
                this.updateWatchDog(watchdogPeriod);
            }
        }
    }

    private synchronized void updateWatchDog(long watchDogPeriod) {
        this.terminateWatchDogTask();
        this.watchDogTask = new WatchDogTask(this);
        HttpClientConnection.schedule(this.watchDogTask, watchDogPeriod, watchDogPeriod);
    }

    private synchronized void terminateWatchDogTask() {
        if (this.watchDogTask != null) {
            this.watchDogTask.close();
        }
    }

    @Override
    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    private void checkTimeouts() {
        try {
            long currentMillis = System.currentTimeMillis();
            Object[] objectArray = this.handlersWaitingForResponseHeader.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object hdl = objectArray[n2];
                boolean isTimeoutReached = ((MessageHeaderHandler)hdl).isResponseTimeoutReached(currentMillis);
                if (isTimeoutReached) {
                    if (this.handlersWaitingForResponseHeader.remove(hdl)) {
                        this.onResponseTimeout((MessageHeaderHandler)hdl);
                    }
                    this.destroy();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.warning("exception occured by checking timouts. " + DataConverter.toString(e));
        }
    }

    private void onResponseTimeout(MessageHeaderHandler internalResponseHandler) {
        SocketTimeoutException ste = new SocketTimeoutException("response timeout " + DataConverter.toFormatedDuration(internalResponseHandler.getTimeout()) + " reached");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(ste.getMessage());
        }
        internalResponseHandler.onException(ste);
        this.destroy();
    }

    private boolean isValid() {
        return this.isOpen() && this.isPersistent();
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        if (requestHeader.getContentLength() != -1) {
            return this.send(requestHeader, requestHeader.getContentLength(), responseHandler);
        }
        if (this.isValid()) {
            if (responseHandler == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("waring no response handler is set. ignoring response");
                }
                responseHandler = HttpClientConnection.newDoNothingResponseHandler();
            }
            if (requestHeader.getTransferEncoding() == null) {
                requestHeader.setHeader("Transfer-Encoding", "chunked");
            }
            this.enhanceHeader(requestHeader);
            try {
                return this.sendInternal(requestHeader, responseHandler);
            }
            catch (IOException ioe) {
                String msg = "can not send request \r\n " + requestHeader.toString() + "\r\n\r\nhttpConnection:\r\n" + this.toString() + "\r\n\r\nreason:\r\n" + ioe.toString();
                this.destroy();
                throw new IOException(msg);
            }
        }
        throw new ClosedChannelException();
    }

    private BodyDataSink sendInternal(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        AbstractHttpConnection.ResponseHandlerAdapter adapter = new AbstractHttpConnection.ResponseHandlerAdapter(responseHandler, requestHeader);
        this.addMessageHeaderHandler(new MessageHeaderHandler(adapter, requestHeader, this.responseTimeoutMillis));
        if (!adapter.isContinueHandler() && HttpUtils.isContainExpect100ContinueHeader(requestHeader)) {
            LOG.warning("Request contains 'Excect: 100-coninue' header and response handler is not annotated with Supports100Continue. Removing Expect header");
            requestHeader.removeHeader("Expect");
        }
        BodyDataSink dataSink = this.writeMessage(Integer.MAX_VALUE, requestHeader);
        return dataSink;
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        if (this.isValid()) {
            if (responseHandler == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("waring no response handler is set. ignoring response");
                }
                responseHandler = HttpClientConnection.newDoNothingResponseHandler();
            }
            if (requestHeader.getContentLength() != -1) {
                requestHeader.removeHeader("Content-Length");
            }
            if (requestHeader.getTransferEncoding() == null) {
                requestHeader.setHeader("Transfer-Encoding", "chunked");
            }
            this.enhanceHeader(requestHeader);
            try {
                if (requestHeader.getTransferEncoding() != null && requestHeader.getTransferEncoding().equalsIgnoreCase("chunked")) {
                    requestHeader.removeHeader("Transfer-Encoding");
                }
                if (requestHeader.getContentLength() == -1) {
                    requestHeader.setContentLength(contentLength);
                }
                return this.sendInternal(requestHeader, contentLength, responseHandler);
            }
            catch (IOException ioe) {
                String msg = "can not send request \r\n " + requestHeader.toString() + "\r\n\r\nhttpConnection:\r\n" + this.toString() + "\r\n\r\nreason:\r\n" + ioe.toString();
                this.destroy();
                throw new IOException(msg);
            }
        }
        throw new ClosedChannelException();
    }

    private BodyDataSink sendInternal(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        AbstractHttpConnection.ResponseHandlerAdapter adapter = new AbstractHttpConnection.ResponseHandlerAdapter(responseHandler, requestHeader);
        this.addMessageHeaderHandler(new MessageHeaderHandler(adapter, requestHeader, this.responseTimeoutMillis));
        if (!adapter.isContinueHandler() && HttpUtils.isContainExpect100ContinueHeader(requestHeader)) {
            LOG.warning("Request contains 'Excect: 100-coninue' header and response handler is not annotated with Supports100Continue. Removing Expect header");
            requestHeader.removeHeader("Expect");
        }
        BodyDataSink dataSink = this.writeMessage(requestHeader, contentLength);
        return dataSink;
    }

    @Override
    public IFutureResponse send(IHttpRequest request) throws IOException, ConnectException {
        if (request.hasBody() && HttpUtils.isContainsExpect100ContinueHeader(request)) {
            if (HttpClientConnection.isNetworkendpoint(request.getNonBlockingBody())) {
                request.setAttribute(IS_AUTOCONTINUE_DEACTIVATED, true);
            }
            if (request.getAttribute(IS_AUTOCONTINUE_DEACTIVATED) == null || !((Boolean)request.getAttribute(IS_AUTOCONTINUE_DEACTIVATED)).booleanValue()) {
                FutureContinueResponseHandler responseHandler = new FutureContinueResponseHandler(request.getRequestHeader(), request.getNonBlockingBody(), this.getId());
                BodyDataSink dataSink = this.send(request.getRequestHeader(), (IHttpResponseHandler)responseHandler);
                dataSink.setFlushmode(IConnection.FlushMode.ASYNC);
                responseHandler.setBodyDataSink(dataSink);
                dataSink.flush();
                return responseHandler;
            }
        }
        FutureResponseHandler responseHandler = new FutureResponseHandler();
        this.send(request, (IHttpResponseHandler)responseHandler);
        return responseHandler;
    }

    @Override
    public void send(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        if (this.isValid()) {
            if (responseHandler == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("waring no response handler is set. ignoring response");
                }
                responseHandler = HttpClientConnection.newDoNothingResponseHandler();
            }
            IHttpRequestHeader requestHeader = request.getRequestHeader();
            this.enhanceHeader(requestHeader);
            try {
                this.sendInternal(request, responseHandler);
            }
            catch (IOException ioe) {
                String msg = "can not send request \r\n " + request.toString() + "\r\n\r\nhttpConnection:\r\n" + this.toString() + "\r\n\r\nreason:\r\n" + ioe.toString();
                this.destroy();
                throw new IOException(msg);
            }
        } else {
            throw new ClosedChannelException();
        }
    }

    private void sendInternal(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        AbstractHttpConnection.ResponseHandlerAdapter adapter = new AbstractHttpConnection.ResponseHandlerAdapter(responseHandler, request.getRequestHeader());
        this.addMessageHeaderHandler(new MessageHeaderHandler(adapter, request.getRequestHeader(), this.responseTimeoutMillis));
        if (!adapter.isContinueHandler() && HttpUtils.isContainExpect100ContinueHeader(request.getRequestHeader())) {
            request.getNonBlockingBody().getReadBufferVersion();
            LOG.warning("Request contains 'Excect: 100-continue' header and response handler is not annotated with Supports100Continue. Removing Expect header");
            request.getRequestHeader().removeHeader("Expect");
        }
        if (request.hasBody()) {
            if (request.getNonBlockingBody().getDataHandler() != null) {
                throw new IOException("a body handler is already assigned to the message body. sending such messages is not supported (remove data handler)");
            }
            if (HttpClientConnection.isForwardable(request.getNonBlockingBody())) {
                BodyDataSink dataSink = this.send(request.getRequestHeader(), responseHandler);
                HttpClientConnection.forwardBody(request.getNonBlockingBody(), dataSink);
            } else {
                this.writeMessage(Integer.MAX_VALUE, request);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] sending (bodyless): " + request.getRequestHeader());
            }
            BodyDataSink bodyDataSink = this.writeMessage(request.getRequestHeader(), 0);
            bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
            bodyDataSink.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageHeaderHandler(MessageHeaderHandler handler) {
        ArrayList<MessageHeaderHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            this.handlersWaitingForResponseHeader.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageHeaderHandlerFirst(MessageHeaderHandler handler) {
        ArrayList<MessageHeaderHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            ArrayList hdls = new ArrayList();
            this.handlersWaitingForResponseHeader.removeAll(hdls);
            this.handlersWaitingForResponseHeader.add(handler);
            this.handlersWaitingForResponseHeader.addAll(hdls);
        }
    }

    private void enhanceHeader(IHttpRequestHeader header) throws IOException {
        String userAgent;
        String host = header.getHost();
        if (host == null) {
            header.setHost(this.getRemoteHostInfo());
        }
        if ((userAgent = header.getUserAgent()) == null) {
            header.setUserAgent(HttpClientConnection.getImplementationVersion());
        }
    }

    private static String getImplementationVersion() {
        if (implementationVersion == null) {
            implementationVersion = "xLightweb/" + HttpUtils.getImplementationVersion();
        }
        return implementationVersion;
    }

    private String getRemoteHostInfo() throws IOException {
        InetAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress == null) {
            return "";
        }
        int remotePort = this.getRemotePort();
        return String.valueOf(remoteAddress.getHostName()) + ":" + remotePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractHttpConnection.IMessageHeaderHandler getMessageHeaderHandler() {
        ArrayList<MessageHeaderHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            block5: {
                if (!this.handlersWaitingForResponseHeader.isEmpty()) break block5;
                return null;
            }
            AbstractHttpConnection.IMessageHeaderHandler messageHandler = this.handlersWaitingForResponseHeader.remove(0);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("retrieve (and removing) message handler " + messageHandler);
            }
            return messageHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageHandler(AbstractHttpConnection.IMessageHeaderHandler messageHandler) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("removing message handler " + messageHandler);
        }
        ArrayList<MessageHeaderHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            this.handlersWaitingForResponseHeader.remove(messageHandler);
        }
    }

    static int toInt(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.getId());
            try {
                sb.append(" " + this.getUnderlyingTcpConnection().getLocalAddress() + ":" + this.getUnderlyingTcpConnection().getLocalPort() + " -> " + this.getUnderlyingTcpConnection().getRemoteAddress() + ":" + this.getUnderlyingTcpConnection().getRemotePort());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getNumOpenTransactions() > 0) {
                sb.append(" openTransactions=" + this.getNumOpenTransactions());
            }
            if (!this.getUnderlyingTcpConnection().isOpen()) {
                sb.append("  (closed)");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    static final class ClientExchange
    extends AbstractHttpConnection.AbstractExchange {
        private final NonBlockingConnectionPool pool;
        private final IHttpRequest request;
        private final SessionManager sessionManager;
        private final IHttpResponseHandler rootResponseHandler;
        private final int connectTimeoutMillis;
        private final String defaultEncoding;
        private final long responseTimeoutMillis;
        private final long bodyDataReceiveTimeoutMillis;
        private final boolean isAutoCloseAfterResponse;
        private final boolean isAutoUncompress;
        private final TransactionMonitor transactionMonitor;

        public ClientExchange(String defaultEncoding, NonBlockingConnectionPool pool, SessionManager sessionManager, IHttpResponseHandler rootResponseHandler, IHttpRequest request, int connectTimeoutMillis, long responseTimeoutMillis, long bodyDataReceiveTimeoutMillis, boolean isAutoCloseAfterResponse, boolean isAutoUncompress, TransactionMonitor transactionMonitor) {
            super(null, pool.getWorkerpool());
            this.defaultEncoding = defaultEncoding;
            this.pool = pool;
            this.request = request;
            this.sessionManager = sessionManager;
            this.rootResponseHandler = rootResponseHandler;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.responseTimeoutMillis = responseTimeoutMillis;
            this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
            this.isAutoCloseAfterResponse = isAutoCloseAfterResponse;
            this.isAutoUncompress = isAutoUncompress;
            this.transactionMonitor = transactionMonitor;
        }

        @Override
        public IHttpSession getSession(boolean create) {
            return this.sessionManager.getSession(this.request.getRemoteHost(), this.request.getRequestURI(), create);
        }

        @Override
        public String encodeURL(String url) {
            return url;
        }

        @Override
        public IHttpRequest getRequest() {
            return this.request;
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, this.rootResponseHandler);
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            return this.forwardInternal(requestHeader, null, responseHandler);
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, contentLength, this.rootResponseHandler);
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            return this.forwardInternal(requestHeader, contentLength, responseHandler);
        }

        private BodyDataSink forwardInternal(IHttpRequestHeader requestHeader, Integer contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            URL url = requestHeader.getRequestUrl();
            String host = url.getHost();
            int port = url.getPort();
            boolean isSSL = url.getProtocol().equalsIgnoreCase("HTTPS");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("try to get a connection from pool (waitForConnect = true)");
            }
            INonBlockingConnection con = this.pool.getNonBlockingConnection(InetAddress.getByName(host), this.normalizePort(port, isSSL), true, this.connectTimeoutMillis, isSSL);
            HttpClientConnection httpCon = this.newHttpClientConnection(con);
            this.setHttpConnection(httpCon);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + con.getId() + "] sending request to remote endpoint");
            }
            if (contentLength == null) {
                return httpCon.send(requestHeader, responseHandler);
            }
            return httpCon.send(requestHeader, contentLength, responseHandler);
        }

        @Override
        public void forward(IHttpRequest request) throws IOException, ConnectException, IllegalStateException {
            this.forward(request, this.rootResponseHandler);
        }

        @Override
        public void forward(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            URL url = request.getRequestUrl();
            String host = url.getHost();
            int port = url.getPort();
            boolean isSSL = url.getProtocol().equalsIgnoreCase("HTTPS");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("try to get a connection from pool (waitForConnect = false)");
            }
            ConnectHandler conHdl = new ConnectHandler(request, responseHandler);
            try {
                this.pool.getNonBlockingConnection(InetAddress.getByName(host), this.normalizePort(port, isSSL), (IHandler)conHdl, false, this.connectTimeoutMillis, isSSL);
            }
            catch (IOException ioe) {
                conHdl.onConnectException(null, ioe);
            }
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header) throws IOException, IllegalStateException {
            BodyDataSink dataSink = HttpClientConnection.newInMemoryBodyDataSink(this.toString(), header);
            HttpResponse response = new HttpResponse(header, HttpClientConnection.getDataSourceOfInMemoryBodyDataSink(dataSink));
            this.send(response);
            return dataSink;
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException, IllegalStateException {
            BodyDataSink dataSink = HttpClientConnection.newInMemoryBodyDataSink(this.toString(), header);
            HttpResponse response = new HttpResponse(header, HttpClientConnection.getDataSourceOfInMemoryBodyDataSink(dataSink));
            this.send(response);
            return dataSink;
        }

        @Override
        public void send(IHttpResponse response) throws IOException, IllegalStateException {
            this.ensureResponseHasNotBeenCommitted();
            this.callResponseHandler(this.rootResponseHandler, response);
            if (response.getStatus() > 100) {
                this.setResponseCommited(true);
            }
        }

        @Override
        public void sendError(Exception e) throws IllegalStateException {
            this.sendError(e, this.rootResponseHandler);
        }

        private void sendError(Exception e, IHttpResponseHandler respHdl) throws IllegalStateException {
            if (this.isResponseCommitted()) {
                return;
            }
            IOException ioe = HttpUtils.toIOException(e);
            this.callResponseHandler(respHdl, ioe);
            this.destroy();
        }

        private HttpClientConnection newHttpClientConnection(INonBlockingConnection con) throws IOException {
            HttpClientConnection httpConnection = new HttpClientConnection(con);
            httpConnection.setResponseTimeoutMillis(this.responseTimeoutMillis);
            httpConnection.setBodyDataReceiveTimeoutMillis(this.bodyDataReceiveTimeoutMillis);
            httpConnection.setAutocloseAfterResponse(this.isAutoCloseAfterResponse);
            httpConnection.setAutoUncompress(this.isAutoUncompress);
            httpConnection.setResponseBodyDefaultEncoding(this.defaultEncoding);
            if (this.transactionMonitor != null) {
                httpConnection.setTransactionMonitor(this.transactionMonitor);
            }
            return httpConnection;
        }

        private int normalizePort(int port, boolean isSecured) {
            if (port == -1) {
                if (isSecured) {
                    return 443;
                }
                return 80;
            }
            return port;
        }

        @Execution(value=0)
        private final class ConnectHandler
        implements IConnectHandler,
        IConnectExceptionHandler {
            private final IHttpRequest req;
            private final IHttpResponseHandler respHandler;

            public ConnectHandler(IHttpRequest req, IHttpResponseHandler respHandler) {
                this.req = req;
                this.respHandler = respHandler;
            }

            @Override
            public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
                HttpClientConnection con = ClientExchange.this.newHttpClientConnection(connection);
                ClientExchange.this.setHttpConnection(con);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + con.getId() + "] sending request to " + connection.getRemoteAddress() + ":" + connection.getRemotePort());
                }
                con.send(this.req, this.respHandler);
                return true;
            }

            @Override
            public boolean onConnectException(INonBlockingConnection connection, IOException ioe) throws IOException {
                ClientExchange.this.sendError(ioe, this.respHandler);
                return true;
            }
        }
    }

    private static final class DoNothingMessageHandler
    implements AbstractHttpConnection.IMessageHandler {
        private DoNothingMessageHandler() {
        }

        @Override
        public void onHeaderProcessed() throws IOException {
        }

        @Override
        public void onMessageReceived() throws IOException {
        }

        @Override
        public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
        }
    }

    private static final class InvokeOnMessageReceivedMessageHandler
    implements AbstractHttpConnection.IMessageHandler {
        private final MessageHeaderHandler headerHandler;

        public InvokeOnMessageReceivedMessageHandler(MessageHeaderHandler headerHandler) {
            this.headerHandler = headerHandler;
        }

        @Override
        public void onHeaderProcessed() throws IOException {
        }

        @Override
        public void onMessageReceived() throws IOException {
            this.headerHandler.callResponseHandler();
        }

        @Override
        public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
            this.headerHandler.onHeaderException(ioe, rawData);
        }
    }

    final class MessageHeaderHandler
    implements AbstractHttpConnection.IMessageHeaderHandler {
        private final AtomicBoolean isCommitted = new AtomicBoolean(false);
        private final AbstractHttpConnection.ResponseHandlerAdapter responseHandlerAdapter;
        private final IHttpRequestHeader requestHeader;
        private long timeout = Long.MAX_VALUE;
        private long timeoutDate = Long.MAX_VALUE;
        private IHttpResponse response = null;
        private final boolean is100ContinueExpected;
        private final TimerTask missing100ResponseHandler;
        private boolean is100ResponseNotified;

        public MessageHeaderHandler(AbstractHttpConnection.ResponseHandlerAdapter responseHandlerAdapter, IHttpRequestHeader requestHeader, long responseTimeout) {
            this.responseHandlerAdapter = responseHandlerAdapter;
            this.requestHeader = requestHeader;
            this.timeout = responseTimeout;
            if (responseTimeout != Long.MAX_VALUE && (double)responseTimeout < 8.301034833169298E18) {
                this.timeoutDate = this.timeout + System.currentTimeMillis();
            }
            if (HttpUtils.isContainExpect100ContinueHeader(requestHeader)) {
                this.is100ContinueExpected = true;
                this.is100ResponseNotified = false;
                this.missing100ResponseHandler = new TimerTask(){

                    @Override
                    public void run() {
                        this.cancel();
                        if (!MessageHeaderHandler.this.is100ResponseNotified) {
                            HttpResponseHeader header = new HttpResponseHeader(100);
                            header.setReason("Continue (100-continue response timeout)");
                            header.setAttribute(HttpClientConnection.TIMEOUT_100_CONTINUE_RESPONSE, true);
                            LOG.warning("100-continue timeout reached (" + DataConverter.toFormatedDuration(CONTINUE_TIMEOUT_MILLIS) + "). Generating local 100-continue response");
                            MessageHeaderHandler.this.callResponseHandler(new HttpResponse(header));
                        }
                    }
                };
                HttpClientConnection.schedule(this.missing100ResponseHandler, CONTINUE_TIMEOUT_MILLIS);
            } else {
                this.is100ContinueExpected = false;
                this.is100ResponseNotified = true;
                this.missing100ResponseHandler = null;
            }
        }

        boolean isResponseTimeoutReached(long currentMillis) {
            if (this.isCommitted.get()) {
                return false;
            }
            return currentMillis > this.timeoutDate;
        }

        long getTimeout() {
            return this.timeout;
        }

        @Override
        public IHttpMessageHeader getAssociatedHeader() {
            return this.requestHeader;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AbstractHttpConnection.IMessageHandler onMessageHeaderReceived(IHttpMessage message) throws IOException {
            this.response = (IHttpResponse)message;
            if (HttpClientConnection.this.transactionMonitor != null) {
                HttpClientConnection.this.transactionMonitor.register(HttpClientConnection.this, this.requestHeader, this.response);
            }
            if (LOG.isLoggable(Level.FINE)) {
                if (this.response.hasBody()) {
                    String body = "";
                    String contentType = this.response.getContentType();
                    if (contentType != null && contentType.startsWith("application/x-www-form-urlencode")) {
                        body = String.valueOf(this.response.getNonBlockingBody().toString()) + "\n";
                    }
                    LOG.fine("[" + HttpClientConnection.this.getId() + "] response received from " + HttpClientConnection.this.getRemoteAddress() + ":" + HttpClientConnection.this.getRemotePort() + " (" + HttpClientConnection.this.getCountMessagesReceived() + ". request) " + this.response.getMessageHeader().toString() + body);
                } else {
                    LOG.fine("[" + HttpClientConnection.this.getId() + "] bodyless response received from " + HttpClientConnection.this.getRemoteAddress() + ":" + HttpClientConnection.this.getRemotePort() + " (" + HttpClientConnection.this.getCountMessagesReceived() + ". request) " + this.response.getMessageHeader().toString());
                }
            }
            boolean isInvokeOnMessageReceived = this.responseHandlerAdapter.isInvokeOnMessageReceived();
            if (this.response.getStatus() >= 100 && this.response.getStatus() < 200) {
                HttpClientConnection.this.setPersistent(true);
            }
            if (this.response.getStatus() == 100) {
                HttpClientConnection.this.addMessageHeaderHandlerFirst(this);
                if (!HttpUtils.isContainExpect100ContinueHeader(this.requestHeader)) return DO_NOTHING_HANDLER;
                isInvokeOnMessageReceived = true;
            } else {
                if (IS_CLOSE_CONNECTION_ON_5XX_RESPONSE && this.response.getStatus() >= 500 && this.response.getStatus() < 600) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("got return code 5xx. Set connection " + HttpClientConnection.this.getId() + " to non persistent");
                    }
                    HttpClientConnection.this.setPersistent(false);
                }
                HttpClientConnection.this.incCountMessageReceived();
                this.handleLifeCycleHeaders(this.response.getResponseHeader());
            }
            if (this.response.hasBody()) {
                if (!isInvokeOnMessageReceived) return new AbstractHttpConnection.IMessageHandler(){

                    @Override
                    public void onHeaderProcessed() throws IOException {
                        MessageHeaderHandler.this.callResponseHandler();
                    }

                    @Override
                    public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + HttpClientConnection.this.getId() + "] error occured by receiving request body " + ioe.toString());
                        }
                        HttpClientConnection.this.destroy();
                    }

                    @Override
                    public void onMessageReceived() throws IOException {
                    }
                };
                return new InvokeOnMessageReceivedMessageHandler(this);
            }
            HttpClientConnection.this.onMessageCompleteReceived(this.response.getResponseHeader());
            return new AbstractHttpConnection.IMessageHandler(){

                @Override
                public void onHeaderProcessed() throws IOException {
                    MessageHeaderHandler.this.callResponseHandler();
                }

                @Override
                public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + HttpClientConnection.this.getId() + "] error occured by receiving request body " + ioe.toString());
                    }
                    HttpClientConnection.this.destroy();
                }

                @Override
                public void onMessageReceived() throws IOException {
                }
            };
        }

        @Override
        public void onHeaderException(IOException ioe, ByteBuffer[] rawData) {
            this.onException(ioe);
        }

        void onException(IOException ioe) {
            this.responseHandlerAdapter.onException(ioe, HttpClientConnection.this);
        }

        public void onMessageReceived() throws IOException {
        }

        public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
            this.onException(ioe);
        }

        private void callResponseHandler() {
            if (this.is100ContinueExpected) {
                this.callSafeResponseHandler(this.response);
            } else {
                this.callUnSafeResponseHandler(this.response);
            }
        }

        private void callUnSafeResponseHandler(IHttpResponse response) {
            this.callResponseHandler(response);
        }

        private synchronized void callSafeResponseHandler(IHttpResponse response) {
            if (this.missing100ResponseHandler != null) {
                this.missing100ResponseHandler.cancel();
            }
            this.callResponseHandler(response);
        }

        private void callResponseHandler(IHttpResponse response) {
            if (response.getStatus() == 100) {
                if (!this.is100ResponseNotified) {
                    this.is100ResponseNotified = true;
                    this.responseHandlerAdapter.onResponse(response, HttpClientConnection.this);
                }
            } else {
                this.isCommitted.set(true);
                this.responseHandlerAdapter.onResponse(response, HttpClientConnection.this);
            }
        }

        void callResponseHandler(IOException ioe) {
            this.isCommitted.set(true);
            this.responseHandlerAdapter.onException(ioe, HttpClientConnection.this);
        }

        private void handleLifeCycleHeaders(IHttpResponseHeader responseHeader) throws IOException {
            if (responseHeader.getProtocol() != null && responseHeader.getProtocol().equals("HTTP/1.1")) {
                HttpClientConnection.this.setPersistent(HttpClientConnection.this.isPersistent());
            } else if (this.requestHeader.getMethod().equals("CONNECT")) {
                HttpClientConnection.this.setPersistent(HttpClientConnection.this.isPersistent());
            }
            this.handleConnectionHeaders(responseHeader);
        }

        private void handleConnectionHeaders(IHttpResponseHeader responseHeader) throws IOException {
            String connectionHeader;
            int n;
            String keepAliveHeader = responseHeader.getHeader("KeepAlive");
            if (keepAliveHeader != null) {
                String[] tokens;
                String[] stringArray = tokens = keepAliveHeader.split(",");
                n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    this.handleKeepAlive(token.trim());
                    ++n2;
                }
            }
            if ((connectionHeader = responseHeader.getHeader("Connection")) != null) {
                String[] values;
                String[] stringArray = values = connectionHeader.split(",");
                int n3 = values.length;
                n = 0;
                while (n < n3) {
                    String value = stringArray[n];
                    if ((value = value.trim()).equalsIgnoreCase("close")) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.finer("[" + HttpClientConnection.this.getId() + " http client connection received 'connection: close' header. set isPersistent=false");
                        }
                        HttpClientConnection.this.setPersistent(false);
                    }
                    ++n;
                }
            }
        }

        private void handleKeepAlive(String option) {
            block9: {
                if (option.toUpperCase().startsWith("TIMEOUT=")) {
                    int timeoutSec = Integer.parseInt(option.substring("TIMEOUT=".length(), option.length()));
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("response keep alive defines timout. set timeout " + timeoutSec + " sec");
                    }
                    HttpClientConnection.this.setResponseTimeoutMillis((long)timeoutSec * 1000L);
                } else if (option.toUpperCase().startsWith("MAX=")) {
                    int maxTransactions = Integer.parseInt(option.substring("MAX=".length(), option.length()));
                    if (maxTransactions == 0) {
                        HttpClientConnection.this.setPersistent(false);
                    }
                } else {
                    try {
                        Integer timeoutSec = Integer.parseInt(option);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("response keep alive defines timout. set timeout " + timeoutSec + " sec");
                        }
                        HttpClientConnection.this.setResponseTimeoutMillis((long)timeoutSec.intValue() * 1000L);
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isLoggable(Level.FINE)) break block9;
                        LOG.fine("unknown kep-alive option '" + option + "'");
                    }
                }
            }
        }
    }

    private static final class WatchDogTask
    extends TimerTask
    implements Closeable {
        private WeakReference<HttpClientConnection> httpClientConnectionRef;

        public WatchDogTask(HttpClientConnection httpClientConnection) {
            this.httpClientConnectionRef = new WeakReference<HttpClientConnection>(httpClientConnection);
        }

        @Override
        public void run() {
            WeakReference<HttpClientConnection> ref = this.httpClientConnectionRef;
            if (ref != null) {
                HttpClientConnection httpClientConnection = (HttpClientConnection)ref.get();
                if (httpClientConnection == null) {
                    this.close();
                } else {
                    httpClientConnection.checkTimeouts();
                }
            }
        }

        @Override
        public void close() {
            this.cancel();
            this.httpClientConnectionRef = null;
        }
    }
}

