/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeaderWrapper;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.Supports100Continue;
import org.xlightweb.client.HttpClient;
import org.xlightweb.client.HttpClientConnection;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;

@Supports100Continue
final class ProxyHandler
implements IHttpRequestHandler {
    private static final Logger LOG = Logger.getLogger(ProxyHandler.class.getName());
    private final HttpClient httpClient;
    private String proxyHost;
    private int proxyPort = -1;
    private String securedProxyHost;
    private int securedProxyPort = -1;
    private String proxyUser;
    private String proxyPassword;
    private String proxyUserPassword;

    public ProxyHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setSecuredProxyHost(String host) {
        if (host != null && host.length() == 0) {
            host = null;
        }
        this.securedProxyHost = host;
    }

    public void setSecuredProxyPort(int proxyPort) {
        this.securedProxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        if (this.proxyPassword != null) {
            try {
                this.proxyUserPassword = new String(HttpUtils.encodeBase64((String.valueOf(proxyUser) + ":" + this.proxyPassword).getBytes()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        if (this.proxyUser != null) {
            try {
                this.proxyUserPassword = new String(HttpUtils.encodeBase64((String.valueOf(this.proxyUser) + ":" + proxyPassword).getBytes()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
    }

    public void setProxyHost(String host) {
        if (host != null && host.length() == 0) {
            host = null;
        }
        this.proxyHost = host;
    }

    @Override
    public void onRequest(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        if (!this.hasProxytoUse(request)) {
            exchange.forward(request);
            return;
        }
        if (request.isSecure()) {
            this.connectAndForward(exchange, true);
        } else if (request.getHeader("Connection") != null && request.getHeader("Connection").equalsIgnoreCase("Upgrade")) {
            this.connectAndForward(exchange, false);
        } else {
            this.forward(exchange);
        }
    }

    private boolean hasProxytoUse(IHttpRequest request) {
        if (!request.isSecure() && this.proxyHost == null) {
            return false;
        }
        return !request.isSecure() || this.securedProxyHost != null || this.proxyHost != null;
    }

    private void forward(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        if (this.proxyUser != null) {
            if (this.proxyUserPassword != null) {
                request.addHeader("Proxy-Authorization", "Basic " + this.proxyUserPassword);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("proxy password is not send send error");
                }
                exchange.sendError(new IOException("proxy user password is not set (hint: usage <HttpClient>.setProxyPassword(...)"));
                return;
            }
        }
        HttpRequest wrappedRequest = null;
        wrappedRequest = request.hasBody() ? new HttpRequest((IHttpRequestHeader)new SimpleForwardRequestHeaderWrapper(request.getRequestHeader()), request.getNonBlockingBody()) : new HttpRequest(new SimpleForwardRequestHeaderWrapper(request.getRequestHeader()));
        exchange.forward(wrappedRequest);
    }

    private void connectAndForward(IHttpExchange exchange, boolean isActivateSecuredMode) throws IOException {
        String host = this.proxyHost;
        int port = this.proxyPort;
        if (this.securedProxyHost != null) {
            host = this.securedProxyHost;
            port = this.securedProxyPort;
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (isActivateSecuredMode) {
                LOG.fine("opening a secured tunnel to " + host + ":" + port);
            } else {
                LOG.fine("opening a plain tunnel to " + host + ":" + port);
            }
        }
        ConnectAndForwardRelay relay = new ConnectAndForwardRelay(exchange, this.proxyUserPassword, isActivateSecuredMode);
        this.httpClient.getUnderlyingConnectionPool().getNonBlockingConnection(host, port, (IHandler)relay, false);
    }

    private final class ConnectAndForwardRelay
    implements IDataHandler,
    IConnectHandler {
        private final IHttpExchange exchange;
        private final String proxyAuthorization;
        private final boolean isActivateSecuredMode;
        private final AtomicBoolean isHandshake = new AtomicBoolean(false);

        public ConnectAndForwardRelay(IHttpExchange exchange, String proxyAuthorization, boolean isActivateSecuredMode) {
            this.exchange = exchange;
            this.proxyAuthorization = proxyAuthorization;
            this.isActivateSecuredMode = isActivateSecuredMode;
        }

        @Override
        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, ClosedChannelException, MaxReadSizeExceededException {
            if (this.isHandshake.getAndSet(false)) {
                int idx;
                String header = connection.readStringByDelimiter("\r\n\r\n");
                String[] lines = header.split("\r\n");
                String statusAndReason = lines[0].substring(idx = lines[0].indexOf(" "), lines[0].length()).trim();
                if (!statusAndReason.startsWith("200")) {
                    this.exchange.sendError(new IOException("could not set up tunnel to " + this.exchange.getRequest().getHeader("Host") + " got " + statusAndReason));
                    connection.close();
                    return true;
                }
                if (this.isActivateSecuredMode) {
                    connection.activateSecuredMode();
                }
                this.send(connection);
            }
            return true;
        }

        @Override
        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException {
            if (connection.getReadBufferVersion() == 0) {
                this.handshakeAndSendLater(connection);
            } else {
                this.send(connection);
            }
            return true;
        }

        private void handshakeAndSendLater(INonBlockingConnection connection) throws IOException {
            String host;
            this.isHandshake.set(true);
            String forwardHost = host = this.exchange.getRequest().getHeader("Host");
            int forwardPort = 443;
            int idx = host.lastIndexOf(":");
            if (idx != -1) {
                forwardPort = Integer.parseInt(host.substring(idx + 1, host.length()));
                forwardHost = host.substring(0, idx);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("CONNECT ").append(forwardHost).append(":").append(forwardPort).append(" HTTP/1.1\r\nHost: ").append(host).append("\r\nUser-Agent: xLightweb/").append(HttpUtils.getImplementationVersion()).append("\r\n");
            if (this.proxyAuthorization != null) {
                sb.append("Proxy-Authorization: Basic ").append(this.proxyAuthorization).append("\r\n");
            }
            sb.append("Proxy-Connection: keep-alive\r\n\r\n");
            connection.write(sb.toString());
            connection.flush();
        }

        public void send(INonBlockingConnection connection) throws IOException {
            connection.setHandler(null);
            final HttpClientConnection tunnel = new HttpClientConnection(connection);
            tunnel.setResponseTimeoutMillis(ProxyHandler.this.httpClient.getResponseTimeoutMillis());
            tunnel.setBodyDataReceiveTimeoutMillis(ProxyHandler.this.httpClient.getBodyDataReceiveTimeoutMillis());
            tunnel.setAutocloseAfterResponse(true);
            IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                @Override
                public void onResponse(IHttpResponse response) throws IOException {
                    HttpClientConnection.addConnectionAttribute(response.getResponseHeader(), tunnel);
                    ConnectAndForwardRelay.this.exchange.send(response);
                }

                @Override
                public void onException(IOException ioe) throws IOException {
                    ConnectAndForwardRelay.this.exchange.sendError(ioe);
                }
            };
            tunnel.send(this.exchange.getRequest(), respHdl);
        }
    }

    private final class SimpleForwardRequestHeaderWrapper
    extends HttpRequestHeaderWrapper {
        public SimpleForwardRequestHeaderWrapper(IHttpRequestHeader delegate) {
            super(delegate);
        }

        @Override
        public URL getRequestUrl() {
            try {
                URL orgURL = this.getWrappedRequestHeader().getRequestUrl();
                int port = ProxyHandler.this.proxyPort;
                if (port == -1) {
                    port = 80;
                }
                URL url = new URL("http", ProxyHandler.this.proxyHost, port, orgURL.getFile());
                return url;
            }
            catch (MalformedURLException murl) {
                throw new RuntimeException(murl.toString());
            }
        }

        @Override
        public String toString() {
            String s = this.getWrappedRequestHeader().toString();
            int idx = s.indexOf("\r\n");
            StringBuilder sb = new StringBuilder(String.valueOf(this.getMethod()) + " http://" + this.getHost() + this.getRequestURI());
            if (this.getQueryString() != null) {
                sb.append("?");
                sb.append(this.getQueryString());
            }
            sb.append(" ");
            sb.append(this.getProtocol());
            sb.append("\r\n");
            sb.append(s.substring(idx + 2, s.length()));
            return sb.toString();
        }
    }
}

