/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpRequest;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.ProtocolException;
import org.xlightweb.Supports100Continue;
import org.xlightweb.client.DuplicatingBodyForwarder;
import org.xlightweb.client.HttpClient;
import org.xlightweb.client.HttpClientConnection;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;

@Supports100Continue
final class RetryHandler
implements IHttpRequestHandler {
    private static final Logger LOG = Logger.getLogger(RetryHandler.class.getName());
    private static final int MAX_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.xlightweb.retryhandler.maxBufferSize", "4194304"));
    static final String RETRY_KEY = "org.xlightweb.client.RetryHandler.retry";
    private static final String RETRY_COUNT_KEY = "org.xlightweb.client.RetryHandler.countTrials";
    private static final String RETRY_PREVIOUS_EXCEPTION_KEY = "org.xlightweb.client.RetryHandler.previousException";
    private static final String RETRY_PREVIOUS_ERROR_RESPONSE_KEY = "org.xlightweb.client.RetryHandler.previousErrorResponse";
    private final HttpClient httpClient;

    public RetryHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    static boolean isRetryable(IOException ioe) {
        return ProtocolException.class.isAssignableFrom(ioe.getClass()) && !RetryHandler.isErrorStatusCodeRecevied((ProtocolException)ioe);
    }

    private static boolean isErrorStatusCodeRecevied(ProtocolException pe) {
        IHttpResponseHeader header = (IHttpResponseHeader)HttpClientConnection.getReceivedHeader(pe);
        return header != null && header.getStatus() >= 400;
    }

    private static boolean isRetryable(int status) {
        return status == 408 || status == 421 || status == 423 || status == 500 || status == 502 || status == 503 || status == 504 || status == 509;
    }

    private static boolean isErrorStatus(int status) {
        return status == 408 || status == 421 || status == 423 || status >= 500;
    }

    @Override
    public void onRequest(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        Boolean retry = (Boolean)request.getAttribute(RETRY_KEY);
        if (retry == null) {
            retry = true;
        }
        if (request.getHeader("Upgrade") != null) {
            retry = false;
        }
        if (retry.booleanValue()) {
            if (request.getMethod().equalsIgnoreCase("GET") || request.getMethod().equalsIgnoreCase("DELETE")) {
                BodylessRetryResponseHandler retryHandler = new BodylessRetryResponseHandler(exchange, request.getRequestHeader().copy());
                exchange.forward(request, (IHttpResponseHandler)retryHandler);
                return;
            }
            if (request.getMethod().equalsIgnoreCase("PUT")) {
                BodyRetryResponseHandler retryHandler = new BodyRetryResponseHandler(exchange, request.getRequestHeader().copy());
                BodyDataSink dataSink = exchange.forward(request.getRequestHeader(), (IHttpResponseHandler)retryHandler);
                dataSink.setFlushmode(IConnection.FlushMode.ASYNC);
                DuplicatingBodyForwarder forwarder = new DuplicatingBodyForwarder(request.getNonBlockingBody(), new DuplicatingBodyForwarder.BodyDataSinkAdapter(dataSink), retryHandler);
                HttpClientConnection.setDataHandlerSilence(request.getNonBlockingBody(), forwarder);
                return;
            }
        }
        exchange.forward(request);
    }

    private static void setPreviousError(IHttpRequestHeader header, IOException ioe, IHttpResponse errorResponse) {
        if (header.getAttribute(RETRY_PREVIOUS_EXCEPTION_KEY) == null && header.getAttribute(RETRY_PREVIOUS_ERROR_RESPONSE_KEY) == null) {
            if (errorResponse != null) {
                header.setAttribute(RETRY_PREVIOUS_ERROR_RESPONSE_KEY, errorResponse);
            } else {
                header.setAttribute(RETRY_PREVIOUS_EXCEPTION_KEY, ioe);
            }
        }
    }

    private static void sendError(IHttpExchange exchange, IHttpRequestHeader header, IOException ioe, IHttpResponse errorResponse) {
        if (header.getAttribute(RETRY_PREVIOUS_ERROR_RESPONSE_KEY) != null) {
            try {
                exchange.send((IHttpResponse)header.getAttribute(RETRY_PREVIOUS_ERROR_RESPONSE_KEY));
            }
            catch (IOException e) {
                exchange.sendError(e);
            }
        } else if (header.getAttribute(RETRY_PREVIOUS_EXCEPTION_KEY) != null) {
            exchange.sendError((IOException)header.getAttribute(RETRY_PREVIOUS_EXCEPTION_KEY));
        } else if (errorResponse != null) {
            try {
                exchange.send(errorResponse);
            }
            catch (IOException e) {
                exchange.sendError(e);
            }
        } else if (ioe != null) {
            exchange.sendError(ioe);
        } else {
            exchange.sendError(500);
        }
    }

    @Supports100Continue
    private final class BodyRetryResponseHandler
    implements IHttpResponseHandler,
    DuplicatingBodyForwarder.ISink {
        private final IHttpExchange exchange;
        private final IHttpRequestHeader requestHeader;
        private final DuplicatingBodyForwarder.InMemorySink inMemorySink = new DuplicatingBodyForwarder.InMemorySink(RetryHandler.access$0()){

            @Override
            void onMaxBufferSizeExceeded() {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("max buffer size (" + DataConverter.toFormatedBytesSize(MAX_BUFFER_SIZE) + ") for request body exceeded. Retry support for this request is deactivated (set the buffer size by using the system property 'org.xlightweb.retryhandler.maxBufferSize')");
                }
                super.onMaxBufferSizeExceeded();
            }
        };
        private Integer countTrials;

        BodyRetryResponseHandler(IHttpExchange exchange, IHttpRequestHeader requestHeader) {
            this.exchange = exchange;
            this.requestHeader = requestHeader;
            this.countTrials = (Integer)requestHeader.getAttribute(RetryHandler.RETRY_COUNT_KEY);
            if (this.countTrials == null) {
                this.countTrials = 0;
            }
        }

        @Override
        public void onData(ByteBuffer data) throws IOException {
            this.inMemorySink.onData(data);
        }

        @Override
        public void close() throws IOException {
            this.inMemorySink.close();
        }

        @Override
        public void destroy() {
            this.inMemorySink.destroy();
        }

        @Override
        public void setDestroyListener(IBodyDestroyListener destroyListener) {
            this.inMemorySink.setDestroyListener(destroyListener);
        }

        @Override
        public String getId() {
            return this.inMemorySink.getId();
        }

        @Override
        public void onResponse(IHttpResponse response) throws IOException {
            if (RetryHandler.isErrorStatus(response.getStatus())) {
                if (RetryHandler.isRetryable(response.getStatus())) {
                    RetryHandler.setPreviousError(this.requestHeader, null, response);
                    if (this.countTrials < RetryHandler.this.httpClient.getMaxRetries() && !this.inMemorySink.isDestroyed()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("retry sending request (retry " + (this.countTrials + 1) + " of " + RetryHandler.this.httpClient.getMaxRetries() + "). got " + response.getStatus() + " " + response.getReason() + " by calling " + this.requestHeader.getRequestUrl().toString());
                        }
                        this.sendRetry();
                        return;
                    }
                }
                RetryHandler.sendError(this.exchange, this.requestHeader, null, response);
            } else {
                this.exchange.send(response);
            }
        }

        @Override
        public void onException(IOException ioe) throws IOException {
            if (RetryHandler.isRetryable(ioe)) {
                RetryHandler.setPreviousError(this.requestHeader, ioe, null);
                if (this.countTrials < RetryHandler.this.httpClient.getMaxRetries() && !this.inMemorySink.isDestroyed()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("retry sending request (retry " + (this.countTrials + 1) + " of " + RetryHandler.this.httpClient.getMaxRetries() + "). I/O exception " + ioe.toString() + " caught when processing request " + this.requestHeader.getRequestUrl().toString());
                    }
                    this.sendRetry();
                } else {
                    RetryHandler.sendError(this.exchange, this.requestHeader, ioe, null);
                }
            } else {
                RetryHandler.sendError(this.exchange, this.requestHeader, ioe, null);
            }
        }

        private void sendRetry() throws IOException {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        IHttpRequestHeader iHttpRequestHeader = BodyRetryResponseHandler.this.requestHeader;
                        BodyRetryResponseHandler bodyRetryResponseHandler = BodyRetryResponseHandler.this;
                        Integer n = bodyRetryResponseHandler.countTrials + 1;
                        bodyRetryResponseHandler.countTrials = n;
                        iHttpRequestHeader.setAttribute(RetryHandler.RETRY_COUNT_KEY, n);
                        BodyRetryResponseHandler.this.requestHeader.setAttribute("org.xlightweb.client.cookieHandler.cookieWarning", false);
                        IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                            @Override
                            @Execution(value=0)
                            public void onResponse(IHttpResponse response) throws IOException {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("forward response");
                                }
                                BodyRetryResponseHandler.this.exchange.send(response);
                            }

                            @Override
                            @Execution(value=0)
                            public void onException(IOException ioe) throws IOException {
                                RetryHandler.sendError(BodyRetryResponseHandler.this.exchange, BodyRetryResponseHandler.this.requestHeader, ioe, null);
                            }
                        };
                        BodyDataSink ds = RetryHandler.this.httpClient.send(BodyRetryResponseHandler.this.requestHeader, respHdl);
                        ds.setFlushmode(IConnection.FlushMode.ASYNC);
                        boolean isForwarding = BodyRetryResponseHandler.this.inMemorySink.forwardTo(new DuplicatingBodyForwarder.BodyDataSinkAdapter(ds));
                        if (!isForwarding) {
                            RetryHandler.sendError(BodyRetryResponseHandler.this.exchange, BodyRetryResponseHandler.this.requestHeader, null, null);
                        }
                    }
                    catch (IOException ioe) {
                        RetryHandler.sendError(BodyRetryResponseHandler.this.exchange, BodyRetryResponseHandler.this.requestHeader, ioe, null);
                    }
                }
            };
            RetryHandler.this.httpClient.getWorkerpool().execute(task);
        }
    }

    @Supports100Continue
    private final class BodylessRetryResponseHandler
    implements IHttpResponseHandler {
        private final AtomicBoolean isHandled = new AtomicBoolean(false);
        private final IHttpExchange exchange;
        private final IHttpRequestHeader requestHeader;
        private Integer countTrials;

        BodylessRetryResponseHandler(IHttpExchange exchange, IHttpRequestHeader requestHeader) {
            this.exchange = exchange;
            this.requestHeader = requestHeader;
            this.countTrials = (Integer)requestHeader.getAttribute(RetryHandler.RETRY_COUNT_KEY);
            if (this.countTrials == null) {
                this.countTrials = 0;
            }
        }

        @Override
        public void onResponse(IHttpResponse response) throws IOException {
            if (!this.isHandled.getAndSet(true)) {
                if (RetryHandler.isErrorStatus(response.getStatus())) {
                    if (RetryHandler.isRetryable(response.getStatus())) {
                        RetryHandler.setPreviousError(this.requestHeader, null, response);
                        if (this.countTrials < RetryHandler.this.httpClient.getMaxRetries()) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("retry sending request (retry " + (this.countTrials + 1) + " of " + RetryHandler.this.httpClient.getMaxRetries() + "). got " + response.getStatus() + " " + response.getReason() + " by calling " + this.requestHeader.getRequestUrl().toString());
                            }
                            this.sendRetry();
                            return;
                        }
                    }
                    RetryHandler.sendError(this.exchange, this.requestHeader, null, response);
                } else {
                    this.exchange.send(response);
                }
            }
        }

        @Override
        public void onException(IOException ioe) throws IOException {
            if (!this.isHandled.getAndSet(true)) {
                RetryHandler.setPreviousError(this.requestHeader, ioe, null);
                if (RetryHandler.isRetryable(ioe)) {
                    if (this.countTrials < RetryHandler.this.httpClient.getMaxRetries()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("retry sending request (retry " + (this.countTrials + 1) + " of " + RetryHandler.this.httpClient.getMaxRetries() + "). I/O exception " + ioe.toString() + " caught when processing request " + this.requestHeader.getRequestUrl().toString());
                        }
                        this.sendRetry();
                    } else {
                        RetryHandler.sendError(this.exchange, this.requestHeader, ioe, null);
                    }
                } else {
                    RetryHandler.sendError(this.exchange, this.requestHeader, ioe, null);
                }
            }
        }

        private void sendRetry() throws IOException {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        IHttpRequestHeader iHttpRequestHeader = BodylessRetryResponseHandler.this.requestHeader;
                        BodylessRetryResponseHandler bodylessRetryResponseHandler = BodylessRetryResponseHandler.this;
                        Integer n = bodylessRetryResponseHandler.countTrials + 1;
                        bodylessRetryResponseHandler.countTrials = n;
                        iHttpRequestHeader.setAttribute(RetryHandler.RETRY_COUNT_KEY, n);
                        BodylessRetryResponseHandler.this.requestHeader.setAttribute("org.xlightweb.client.cookieHandler.cookieWarning", false);
                        IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                            @Override
                            @Execution(value=0)
                            public void onResponse(IHttpResponse response) throws IOException {
                                BodylessRetryResponseHandler.this.exchange.send(response);
                            }

                            @Override
                            @Execution(value=0)
                            public void onException(IOException ioe) throws IOException {
                                RetryHandler.sendError(BodylessRetryResponseHandler.this.exchange, BodylessRetryResponseHandler.this.requestHeader, ioe, null);
                            }
                        };
                        RetryHandler.this.httpClient.send(new HttpRequest(BodylessRetryResponseHandler.this.requestHeader), respHdl);
                    }
                    catch (IOException ioe) {
                        RetryHandler.sendError(BodylessRetryResponseHandler.this.exchange, BodylessRetryResponseHandler.this.requestHeader, ioe, null);
                    }
                }
            };
            RetryHandler.this.httpClient.getWorkerpool().execute(task);
        }
    }
}

