/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xlightweb.BadMessageException;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpConnectHandler;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.server.HttpServer;
import org.xlightweb.server.HttpServerConnection;
import org.xlightweb.server.HttpSession;
import org.xlightweb.server.ISessionManager;
import org.xlightweb.server.IUpgradeHandler;
import org.xlightweb.server.ServerUtils;
import org.xlightweb.server.SessionManager;
import org.xlightweb.server.TransactionMonitor;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.Resource;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;

@Execution(value=0)
public final class HttpProtocolAdapter
implements IConnectHandler,
ILifeCycle,
MBeanRegistration {
    private static final Logger LOG = Logger.getLogger(HttpProtocolAdapter.class.getName());
    private static final boolean DEFAULT_CLOSE_ON_SENDING_ERROR = false;
    private static final NullRequestHandler NULL_REQUESTHANDLER = new NullRequestHandler();
    @Resource
    private IServer server;
    private ISessionManager sessionManager = new SessionManager();
    private boolean useCookies = true;
    private IHttpRequestHandler requestHandler;
    private Object requestHandlerAdapter;
    private IUpgradeHandler upgradeHandler;
    private final List<IHttpConnectionHandler> connectionHandlers = new ArrayList<IHttpConnectionHandler>();
    private Long requestTimeoutMillis;
    private Long bodyDataReceiveTimeoutMillis;
    private boolean isCloseOnSendingError = false;
    private static final int DEFAULT_AUTO_COMPRESS_THRESHOLD = Integer.parseInt(System.getProperty("org.xlightweb.server.response.autocompressThreshold", "512"));
    private int autocompressThresholdBytes = DEFAULT_AUTO_COMPRESS_THRESHOLD;
    private static final boolean DEFAULT_AUTO_UNCOMPRESS = Boolean.parseBoolean(System.getProperty("org.xlightweb.server.request.isAutouncompressActivated", "true"));
    private boolean isAutoUncompress = DEFAULT_AUTO_UNCOMPRESS;
    private Integer maxTransactions;
    private int sessionMaxInactiveIntervalSec = Integer.MAX_VALUE;
    private String defaultEncoding = IHttpMessage.DEFAULT_ENCODING;
    private TransactionMonitor transactionMonitor = null;
    private int numHandledConnections = 0;

    public HttpProtocolAdapter(IHttpRequestHandler requestHandler) {
        this(requestHandler, null);
    }

    HttpProtocolAdapter(IHttpRequestHandler requestHandler, IUpgradeHandler upgradeHandler) {
        if (requestHandler == null) {
            requestHandler = NULL_REQUESTHANDLER;
        } else if (!HttpUtils.isConnectHandlerWarningIsSuppressed() && requestHandler instanceof IHttpConnectHandler) {
            LOG.warning("only IHttpRequestHandler is supported. The onConnect(...) method will not be called. (suppress this warning by setting system property org.xlightweb.httpConnectHandler.suppresswarning=true)");
        }
        this.upgradeHandler = new HttpServerConnection.AutoUpgradeHandler(upgradeHandler);
        this.requestHandler = requestHandler;
        this.requestHandlerAdapter = HttpServerConnection.wrap(requestHandler);
    }

    public IHttpRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setSessionManager(ISessionManager sessionManager) {
        block2: {
            try {
                this.sessionManager.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing session manager " + ioe.toString());
            }
        }
        this.sessionManager = sessionManager;
    }

    void setTransactionMonitor(TransactionMonitor transactionMonitor) {
        this.transactionMonitor = transactionMonitor;
    }

    public void setUsingCookies(boolean useCookies) {
        this.useCookies = useCookies;
    }

    public boolean isUsingCookies() {
        return this.useCookies;
    }

    public ISessionManager getSessionManager() {
        return this.sessionManager;
    }

    int getNumHandledConnections() {
        return this.numHandledConnections;
    }

    public void setRequestBodyDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getRequestBodyDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public ObjectName preRegister(MBeanServer mbeanServer, ObjectName name) throws Exception {
        ISessionManager sessionManager = ((HttpServer)this.server).getSessionManager();
        ObjectName objectName = new ObjectName(String.valueOf(name.getDomain()) + ":type=" + "sessionManager" + ",name=" + sessionManager.hashCode());
        mbeanServer.registerMBean(new SessionManagerInfo(sessionManager), objectName);
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.preRegister(mbeanServer, name);
        }
        return ServerUtils.exportMbean(mbeanServer, name, this.requestHandler);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.postRegister(registrationDone);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.preDeregister();
        }
    }

    @Override
    public void postDeregister() {
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.postDeregister();
        }
    }

    public void setRequestTimeoutMillis(long requesttimeout) {
        if (requesttimeout < 1000L) {
            LOG.warning("try to set request timeout with " + requesttimeout + ". This will be ignored because the value is smaller than the min request timout " + 1000 + " millis");
            return;
        }
        this.requestTimeoutMillis = requesttimeout;
    }

    public void setAutoCompressThresholdBytes(int autocompressThresholdBytes) {
        this.autocompressThresholdBytes = autocompressThresholdBytes;
    }

    public int getAutoCompressThresholdBytes() {
        return this.autocompressThresholdBytes;
    }

    public void setAutoUncompress(boolean isAutoUncompress) {
        this.isAutoUncompress = isAutoUncompress;
    }

    public boolean isAutoUncompress() {
        return this.isAutoUncompress;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
    }

    public long getBodyDataReceiveTimeoutMillis() {
        return this.bodyDataReceiveTimeoutMillis;
    }

    public void setCloseOnSendingError(boolean isCloseOnSendingError) {
        this.isCloseOnSendingError = isCloseOnSendingError;
    }

    public boolean isCloseOnSendingError() {
        return this.isCloseOnSendingError;
    }

    public void setMaxTransactions(int maxTransactions) {
        this.maxTransactions = maxTransactions;
    }

    public int getMaxTransactions() {
        return this.maxTransactions;
    }

    public void setSessionMaxInactiveIntervalSec(int sessionMaxInactiveIntervalSec) {
        this.sessionMaxInactiveIntervalSec = sessionMaxInactiveIntervalSec;
    }

    public int getSessionMaxInactiveIntervalSec() {
        return this.sessionMaxInactiveIntervalSec;
    }

    public void addConnectionHandler(IHttpConnectionHandler connectionHandler) {
        this.connectionHandlers.add(connectionHandler);
    }

    public String getImplementationVersion() {
        return HttpUtils.getImplementationVersion();
    }

    @Override
    public void onInit() {
        this.server.setStartUpLogMessage("xLightweb " + HttpUtils.getImplementationVersion() + "/" + this.server.getStartUpLogMessage());
        ServerUtils.injectServerField(this.requestHandler, this.server);
        ServerUtils.injectProtocolAdapter(this.requestHandler, this);
        if (this.requestHandler instanceof ILifeCycle) {
            ((ILifeCycle)((Object)this.requestHandler)).onInit();
        }
    }

    @Override
    public void onDestroy() throws IOException {
        block3: {
            if (this.requestHandler instanceof ILifeCycle) {
                try {
                    ((ILifeCycle)((Object)this.requestHandler)).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + this.requestHandler + " " + ioe.toString());
                }
            }
        }
        this.sessionManager.close();
        this.connectionHandlers.clear();
        this.server = null;
        this.sessionManager = null;
        this.requestHandler = null;
        this.requestHandlerAdapter = null;
    }

    @Override
    public boolean onConnect(INonBlockingConnection connection) throws IOException {
        ++this.numHandledConnections;
        HttpServerConnection httpCon = new HttpServerConnection(this.defaultEncoding, this.sessionManager, this.transactionMonitor, this.sessionMaxInactiveIntervalSec, connection, this.requestHandlerAdapter, this.upgradeHandler, this.isCloseOnSendingError, this.connectionHandlers, this.useCookies, this.autocompressThresholdBytes, this.isAutoUncompress);
        if (this.maxTransactions != null) {
            httpCon.setMaxTransactions(this.maxTransactions);
        }
        if (this.requestTimeoutMillis != null) {
            httpCon.setRequestTimeoutMillis(this.requestTimeoutMillis);
        }
        if (this.bodyDataReceiveTimeoutMillis != null) {
            httpCon.setBodyDataReceiveTimeoutMillis(this.bodyDataReceiveTimeoutMillis);
        }
        return true;
    }

    @Execution(value=0)
    private static final class NullRequestHandler
    implements IHttpRequestHandler {
        private NullRequestHandler() {
        }

        @Override
        public void onRequest(IHttpExchange exchange) throws IOException, BadMessageException {
        }
    }

    private static final class SessionManagerInfo
    implements SessionManagerInfoMBean {
        private final ISessionManager sessionManager;
        private boolean isShowDetailedInfo = false;

        public SessionManagerInfo(ISessionManager sessionManager) {
            this.sessionManager = sessionManager;
        }

        @Override
        public Integer getNumCreatedSessions() {
            if (this.sessionManager instanceof SessionManager) {
                return ((SessionManager)this.sessionManager).getNumCreatedSessions();
            }
            return null;
        }

        @Override
        public Integer getNumExpiredSessions() {
            if (this.sessionManager instanceof SessionManager) {
                return ((SessionManager)this.sessionManager).getNumExpiredSessions();
            }
            return null;
        }

        @Override
        public Integer getNumRemovedSessions() {
            if (this.sessionManager instanceof SessionManager) {
                return ((SessionManager)this.sessionManager).getNumExpiredSessions();
            }
            return null;
        }

        @Override
        public boolean isShowDetailedInfo() {
            return this.isShowDetailedInfo;
        }

        @Override
        public void setShowDetailedInfo(boolean isShowDetailedInfo) {
            this.isShowDetailedInfo = isShowDetailedInfo;
        }

        @Override
        public int getNumSessions() {
            return this.sessionManager.getSessionMap().size();
        }

        @Override
        public String[] getSessionsInfo() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.isShowDetailedInfo) {
                for (HttpSession session : this.sessionManager.getSessionMap().values()) {
                    result.add("[" + session.getId() + "; serSize=" + DataConverter.toFormatedBytesSize(this.determineSerializedSize(session)) + "] " + session.toString());
                }
            }
            return result.toArray(new String[result.size()]);
        }

        @Override
        public Integer getTotalSessionStoreSize() {
            if (this.isShowDetailedInfo) {
                int size = 0;
                for (HttpSession session : this.sessionManager.getSessionMap().values()) {
                    size += this.determineSerializedSize(session);
                }
                return size;
            }
            return null;
        }

        private int determineSerializedSize(Serializable object) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(object);
                oos.close();
                return bos.toByteArray().length;
            }
            catch (IOException ioe) {
                return -1;
            }
        }
    }

    public static interface SessionManagerInfoMBean {
        public Integer getNumCreatedSessions();

        public Integer getNumRemovedSessions();

        public Integer getNumExpiredSessions();

        public String[] getSessionsInfo();

        public int getNumSessions();

        public Integer getTotalSessionStoreSize();

        public boolean isShowDetailedInfo();

        public void setShowDetailedInfo(boolean var1);
    }
}

