/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.xlightweb.BadMessageException;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IWebHandler;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.server.HttpProtocolAdapter;
import org.xlightweb.server.HttpServerConnection;
import org.xlightweb.server.IHttpServer;
import org.xlightweb.server.ISessionManager;
import org.xlightweb.server.IUpgradeHandler;
import org.xlightweb.server.ServerUtils;
import org.xlightweb.server.TransactionMonitor;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.NonBlockingConnection;
import org.xsocket.connection.Server;

public class HttpServer
extends Server
implements IHttpServer {
    private TransactionMonitor transactionMonitor = null;
    private final TransactionMonitor.TransactionLog transactionLog = new TransactionMonitor.TransactionLog(0);

    public HttpServer(IWebHandler webHandler) throws UnknownHostException, IOException {
        this(webHandler, new HashMap<String, Object>());
    }

    public HttpServer(IWebHandler webHandler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(new InetSocketAddress(0), options, webHandler, null, false, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    public HttpServer(int port, IWebHandler webHandler) throws UnknownHostException, IOException {
        this(port, webHandler, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    public HttpServer(int port, IWebHandler webHandler, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(port, webHandler, null, false, minPoolsize, maxPoolsize);
    }

    public HttpServer(int port, IWebHandler webHandler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(port, webHandler, options, null, false);
    }

    public HttpServer(InetAddress address, int port, IWebHandler webHandler) throws UnknownHostException, IOException {
        this(address, port, webHandler, null, false);
    }

    public HttpServer(String ipAddress, int port, IWebHandler webHandler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, webHandler);
    }

    public HttpServer(String ipAddress, int port, IWebHandler webHandler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, webHandler, options, null, false);
    }

    public HttpServer(int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(port, webHandler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public HttpServer(int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), webHandler, sslContext, sslOn, minPoolsize, maxPoolsize);
    }

    public HttpServer(int port, IWebHandler webHandler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), options, webHandler, sslContext, sslOn, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    public HttpServer(String ipAddress, int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(ipAddress, port, webHandler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public HttpServer(String ipAddress, int port, IWebHandler webHandler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, webHandler, options, sslContext, sslOn);
    }

    public HttpServer(InetAddress address, int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(address, port, webHandler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public HttpServer(InetAddress address, int port, IWebHandler webHandler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, webHandler, sslContext, sslOn, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    HttpServer(InetSocketAddress address, Map<String, Object> options, IWebHandler webHandler, SSLContext sslContext, boolean sslOn, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(address, options, HttpServer.getRequestHandler(webHandler), new WebSocketUpgradeHandler(webHandler), sslContext, sslOn, minPoolsize, maxPoolsize);
    }

    HttpServer(InetSocketAddress address, Map<String, Object> options, IHttpRequestHandler requestHandler, IUpgradeHandler upgradeHandler, SSLContext sslContext, boolean sslOn, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        super(address, options, new HttpProtocolAdapter(requestHandler, upgradeHandler), sslContext, sslOn, 0, minPoolsize, maxPoolsize);
    }

    public void addConnectionHandler(IHttpConnectionHandler connectionHandler) {
        ((HttpProtocolAdapter)super.getHandler()).addConnectionHandler(connectionHandler);
    }

    @Override
    protected final void onPreRejectConnection(NonBlockingConnection connection) throws IOException {
        HttpResponse response = new HttpResponse(503);
        response.setServer(ServerUtils.getComponentInfo());
        response.setHeader("Connection", "close");
        response.setHeader("Content-Length", "0");
        connection.write(response.toString());
    }

    @Override
    public String getImplementationVersion() {
        return HttpUtils.getImplementationVersion();
    }

    int getNumHandledConnections() {
        return ((HttpProtocolAdapter)super.getHandler()).getNumHandledConnections();
    }

    @Override
    public String getImplementationDate() {
        return HttpUtils.getImplementationDate();
    }

    @Override
    public IHttpRequestHandler getRequestHandler() {
        return ((HttpProtocolAdapter)this.getHandler()).getRequestHandler();
    }

    String getXSocketImplementationVersion() {
        return ConnectionUtils.getImplementationVersion();
    }

    String getXSocketImplementationDate() {
        return ConnectionUtils.getImplementationDate();
    }

    @Override
    public void setRequestTimeoutMillis(long receivetimeout) {
        ((HttpProtocolAdapter)super.getHandler()).setRequestTimeoutMillis(receivetimeout);
    }

    @Override
    public void setAutoCompressThresholdBytes(int autocompressThresholdBytes) {
        ((HttpProtocolAdapter)super.getHandler()).setAutoCompressThresholdBytes(autocompressThresholdBytes);
    }

    @Override
    public int getAutoCompressThresholdBytes() {
        return ((HttpProtocolAdapter)super.getHandler()).getAutoCompressThresholdBytes();
    }

    @Override
    public void setAutoUncompress(boolean isAutoUncompress) {
        ((HttpProtocolAdapter)super.getHandler()).setAutoUncompress(isAutoUncompress);
    }

    @Override
    public final boolean isAutoUncompress() {
        return ((HttpProtocolAdapter)super.getHandler()).isAutoUncompress();
    }

    @Override
    public long getRequestTimeoutMillis() {
        return ((HttpProtocolAdapter)super.getHandler()).getRequestTimeoutMillis();
    }

    @Override
    public final void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        ((HttpProtocolAdapter)super.getHandler()).setBodyDataReceiveTimeoutMillis(bodyDataReceiveTimeoutMillis);
    }

    @Override
    public long getBodyDataReceiveTimeoutMillis() {
        return ((HttpProtocolAdapter)super.getHandler()).getBodyDataReceiveTimeoutMillis();
    }

    @Override
    public void setSessionMaxInactiveIntervalSec(int sessionMaxInactiveIntervalSec) {
        ((HttpProtocolAdapter)super.getHandler()).setSessionMaxInactiveIntervalSec(sessionMaxInactiveIntervalSec);
    }

    @Override
    public int getSessionMaxInactiveIntervalSec() {
        return ((HttpProtocolAdapter)super.getHandler()).getSessionMaxInactiveIntervalSec();
    }

    @Override
    public void setCloseOnSendingError(boolean isCloseOnSendingError) {
        ((HttpProtocolAdapter)super.getHandler()).setCloseOnSendingError(isCloseOnSendingError);
    }

    @Override
    public boolean isCloseOnSendingError() {
        return ((HttpProtocolAdapter)super.getHandler()).isCloseOnSendingError();
    }

    @Override
    public void setRequestBodyDefaultEncoding(String defaultEncoding) {
        ((HttpProtocolAdapter)super.getHandler()).setRequestBodyDefaultEncoding(defaultEncoding);
    }

    @Override
    public String getRequestBodyDefaultEncoding() {
        return ((HttpProtocolAdapter)super.getHandler()).getRequestBodyDefaultEncoding();
    }

    @Override
    public void setMaxTransactions(int maxTransactions) {
        ((HttpProtocolAdapter)this.getHandler()).setMaxTransactions(maxTransactions);
    }

    @Override
    public int getMaxTransactions() {
        return ((HttpProtocolAdapter)this.getHandler()).getMaxTransactions();
    }

    @Override
    public void setSessionManager(ISessionManager sessionManager) {
        ((HttpProtocolAdapter)this.getHandler()).setSessionManager(sessionManager);
    }

    @Override
    public ISessionManager getSessionManager() {
        return ((HttpProtocolAdapter)this.getHandler()).getSessionManager();
    }

    @Override
    public void setUsingCookies(boolean useCookies) {
        ((HttpProtocolAdapter)this.getHandler()).setUsingCookies(useCookies);
    }

    @Override
    public boolean isUsingCookies() {
        return ((HttpProtocolAdapter)this.getHandler()).isUsingCookies();
    }

    List<String> getTransactionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        for (TransactionMonitor.Transaction transaction : this.transactionLog.getTransactions()) {
            result.add(transaction.toString());
        }
        return result;
    }

    void setTransactionLogMaxSize(int maxSize) {
        this.transactionLog.setMaxSize(maxSize);
        this.transactionMonitor = maxSize == 0 ? null : new TransactionMonitor(this.transactionLog);
        ((HttpProtocolAdapter)this.getHandler()).setTransactionMonitor(this.transactionMonitor);
    }

    Integer getTransactionsPending() {
        if (this.transactionMonitor != null) {
            return this.transactionMonitor.getPendingTransactions();
        }
        return null;
    }

    int getTransactionLogMaxSize() {
        return this.transactionLog.getMaxSize();
    }

    private static IHttpRequestHandler getRequestHandler(IWebHandler webHandler) {
        if (webHandler == null) {
            return null;
        }
        if (IHttpRequestHandler.class.isAssignableFrom(webHandler.getClass())) {
            return (IHttpRequestHandler)webHandler;
        }
        return null;
    }

    private static final class CompleteListener
    implements IBodyCompleteListener,
    IBodyDestroyListener {
        private final IHttpExchange exchange;
        private final IWebSocketHandler webSocketHandler;

        public CompleteListener(IHttpExchange exchange, IWebSocketHandler webSocketHandler) {
            this.exchange = exchange;
            this.webSocketHandler = webSocketHandler;
        }

        @Override
        public void onComplete() throws IOException {
            new WebSocketConnection((HttpServerConnection)this.exchange.getConnection(), this.webSocketHandler, this.exchange);
        }

        @Override
        public void onDestroyed() throws IOException {
            this.exchange.destroy();
        }
    }

    private static final class WebSocketUpgradeHandler
    implements IUpgradeHandler {
        private final IWebSocketHandler webSocketHandler;

        public WebSocketUpgradeHandler(IWebHandler webHandler) {
            this.webSocketHandler = webHandler != null && IWebSocketHandler.class.isAssignableFrom(webHandler.getClass()) ? (IWebSocketHandler)webHandler : null;
        }

        @Override
        public boolean onRequest(IHttpExchange exchange) throws IOException, BadMessageException {
            IHttpRequest request = exchange.getRequest();
            if (this.webSocketHandler != null && request.getHeader("Upgrade").equalsIgnoreCase("WebSocket") && request.getProtocolVersion().endsWith("1.1")) {
                if (request.hasBody()) {
                    CompleteListener cl = new CompleteListener(exchange, this.webSocketHandler);
                    request.getNonBlockingBody().addCompleteListener(cl);
                    request.getNonBlockingBody().addDestroyListener(cl);
                } else {
                    new WebSocketConnection((HttpServerConnection)exchange.getConnection(), this.webSocketHandler, exchange);
                }
                return true;
            }
            return false;
        }
    }
}

