/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyForwarder;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.server.HttpSession;
import org.xlightweb.server.ISessionManager;
import org.xlightweb.server.IUpgradeHandler;
import org.xlightweb.server.ServerUtils;
import org.xlightweb.server.TransactionMonitor;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.MaxConnectionsExceededException;

public final class HttpServerConnection
extends AbstractHttpConnection {
    private static final Logger LOG = Logger.getLogger(HttpServerConnection.class.getName());
    private static final int CLOSE_DELAY_ON_OPEN_TRANSACTIONS_MILLIS = 1000;
    public static final boolean DEFAULT_REMOVE_REQUEST_CONNECTION_HEADER = false;
    public static final Integer DEFAULT_RECEIVE_TIMEOUT_MILLIS = Integer.MAX_VALUE;
    public static final boolean DEFAULT_AUTOHANDLE_CONNECTION_UPGRADE_HEADER = true;
    public static final boolean DEFAULT_SESSION_MANAGEMENT = true;
    static final int MIN_REQUEST_TIMEOUT_MILLIS = 1000;
    private static final DoNothingMessageHandler DO_NOTHING_HANDLER = new DoNothingMessageHandler();
    private static boolean IS_CLOSE_CONNECTION_ON_5XX_RESPONSE = Boolean.parseBoolean(System.getProperty("org.xlightweb.server.closeConnectionOn5xxResponse", "true"));
    private boolean isCloseOnSendingError = false;
    private boolean isDelayedClosed = false;
    private final ConnectionCloser connectionCloser = new ConnectionCloser();
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 10000L;
    private TimeoutWatchDogTask watchDogTask;
    private Long requestTimeoutMillis;
    private static final boolean IS_SESSION_COOKIE_HTTPONLY = Boolean.parseBoolean(System.getProperty("org.xlightweb.server.sessionCookieHttpOnly", "true"));
    private final ISessionManager sessionManager;
    private final int sessionMaxInactiveIntervalSec;
    private boolean useCookies = true;
    private final int autocompressThresholdBytes;
    private Integer maxTransactions;
    private final TransactionMonitor transactionMonitor;
    private final AbstractHttpConnection.IMessageHeaderHandler messageHandler;
    private final AbstractHttpConnection.RequestHandlerAdapter requestHandlerAdapter;
    boolean isAutohandleUpgadeHeader = true;
    final IUpgradeHandler upgradeHandler;

    HttpServerConnection(String defaultEncoding, ISessionManager sessionManager, TransactionMonitor transactionMonitor, int defaultMaxInactiveIntervalSec, INonBlockingConnection tcpConnection, Object requestHandlerAdapter, IUpgradeHandler upgradeHandler, boolean isCloseOnSendingError, List<IHttpConnectionHandler> connectionHandlers, boolean useCookies, int autocompressThresholdBytes, boolean isAutoUncompress) throws IOException {
        super(tcpConnection, false);
        this.sessionManager = sessionManager;
        this.transactionMonitor = transactionMonitor;
        this.sessionMaxInactiveIntervalSec = defaultMaxInactiveIntervalSec;
        this.isCloseOnSendingError = isCloseOnSendingError;
        this.useCookies = useCookies;
        this.autocompressThresholdBytes = autocompressThresholdBytes;
        this.setAutoUncompress(isAutoUncompress);
        this.requestHandlerAdapter = (AbstractHttpConnection.RequestHandlerAdapter)requestHandlerAdapter;
        if (connectionHandlers != null) {
            for (IHttpConnectionHandler connectionHandler : connectionHandlers) {
                this.addConnectionHandler(connectionHandler);
            }
        }
        this.upgradeHandler = upgradeHandler;
        this.messageHandler = new MessageHeaderHandler();
        this.setBodyDefaultEncoding(defaultEncoding);
        this.init();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] http server connection established");
        }
    }

    @Override
    public boolean isServerSide() {
        return true;
    }

    public void setMaxTransactions(int maxTransactions) {
        this.maxTransactions = maxTransactions;
    }

    public void setRequestBodyDefaultEncoding(String defaultEncoding) {
        this.setBodyDefaultEncoding(defaultEncoding);
    }

    boolean isAutohandleUpgade() {
        return this.isAutohandleUpgadeHeader;
    }

    void setAutohandleUpgade(boolean isAutohandleUpgade) {
        this.isAutohandleUpgadeHeader = isAutohandleUpgade;
    }

    protected static void schedule(TimerTask task, long delay, long period) {
        AbstractHttpConnection.schedule(task, delay, period);
    }

    protected static int getSizeDataReceived(NonBlockingBodyDataSource body) {
        return AbstractHttpConnection.getSizeDataReceived(body);
    }

    protected static int getSizeWritten(BodyDataSink body) {
        return AbstractHttpConnection.getSizeWritten(body);
    }

    static Object wrap(IHttpRequestHandler requestHandler) {
        return new AbstractHttpConnection.RequestHandlerAdapter(requestHandler);
    }

    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        if (requestTimeoutMillis < 1000L) {
            LOG.warning("[" + this.getId() + "] try to set request timeout with " + requestTimeoutMillis + " millis. This value will be ignored because it is smaller that " + 1000 + " millis");
        }
        if (requestTimeoutMillis <= 0L) {
            this.requestHandlerAdapter.onRequestTimeout(this);
            return;
        }
        this.setLastTimeDataReceivedMillis(System.currentTimeMillis());
        if (this.requestTimeoutMillis == null || this.requestTimeoutMillis != requestTimeoutMillis) {
            this.requestTimeoutMillis = requestTimeoutMillis;
            if (requestTimeoutMillis == Long.MAX_VALUE) {
                this.terminateWatchDogTask();
            } else {
                long watchdogPeriod = 100L;
                if (requestTimeoutMillis > 1000L) {
                    watchdogPeriod = requestTimeoutMillis / 10L;
                }
                if (watchdogPeriod > 10000L) {
                    watchdogPeriod = 10000L;
                }
                this.updateWatchDog(watchdogPeriod);
            }
        }
    }

    private void checkRequestTimeout(long currentTimeMillis) {
        if (this.requestTimeoutMillis != null) {
            long timeoutReceived = this.getLastTimeDataReceivedMillis() + this.requestTimeoutMillis;
            long timeoutSend = this.getLastTimeWritten() + this.requestTimeoutMillis;
            if (currentTimeMillis > timeoutReceived && currentTimeMillis > timeoutSend) {
                this.onRequestTimeout();
            }
        }
    }

    private void onRequestTimeout() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] request timeout " + DataConverter.toFormatedDuration(this.requestTimeoutMillis) + " reached");
        }
        this.terminateWatchDogTask();
        this.requestHandlerAdapter.onRequestTimeout(this);
    }

    private synchronized void updateWatchDog(long watchDogPeriod) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] update timeout watchdog task period to " + DataConverter.toFormatedDuration(watchDogPeriod));
        }
        this.terminateWatchDogTask();
        this.watchDogTask = new TimeoutWatchDogTask(this);
        AbstractHttpConnection.schedule(this.watchDogTask, watchDogPeriod, watchDogPeriod);
    }

    private synchronized void terminateWatchDogTask() {
        if (this.watchDogTask != null) {
            this.watchDogTask.close();
            this.watchDogTask = null;
        }
    }

    @Override
    protected void onProtocolException(Exception ex) {
        if (ex instanceof BadMessageException) {
            this.setPersistent(false);
            try {
                this.sendResponseMessage(new HttpResponse(((BadMessageException)ex).getStatus(), "text/html", HttpServerConnection.generateErrorMessageHtml(400, ex.getMessage(), this.getId())), false);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] could not send error message " + 400 + " reason " + ioe.toString());
                }
                this.destroy();
            }
        } else {
            super.onProtocolException(ex);
        }
    }

    @Override
    protected void onMessageWritten() {
        if (!this.isPersistent()) {
            if (this.getNumOpenTransactions() > 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] connection is not persistent. closing it after " + DataConverter.toFormatedDuration(1000L) + " -> openTransactions " + this.getNumOpenTransactions());
                }
                this.isDelayedClosed = true;
                this.destroy(1000);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] connection is not persistent. closing it now");
                }
                this.destroy();
            }
        }
    }

    boolean isDelayedClosed() {
        return this.isDelayedClosed;
    }

    @Override
    protected AbstractHttpConnection.IMessageHeaderHandler getMessageHeaderHandler() {
        return this.messageHandler;
    }

    @Override
    protected void onDisconnect() {
        super.onDisconnect();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] http server connection destroyed");
        }
    }

    private void handleLifeCycleHeaders(IHttpRequest request) {
        String connectionHeader;
        int n;
        IHttpRequestHeader header = request.getRequestHeader();
        String keepAliveHeader = header.getHeader("KeepAlive");
        if (keepAliveHeader != null) {
            String[] tokens;
            String[] stringArray = tokens = keepAliveHeader.split(",");
            n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                this.handleKeepAlive(token);
                ++n2;
            }
        }
        if ((connectionHeader = header.getHeader("Connection")) != null) {
            String[] values;
            String[] stringArray = values = connectionHeader.split(",");
            int n3 = values.length;
            n = 0;
            while (n < n3) {
                String value = stringArray[n];
                if ((value = value.trim()).equalsIgnoreCase("close")) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] received connection: closed header. destroying connection");
                    }
                    this.setPersistent(false);
                }
                if (value.equalsIgnoreCase("Keep-Alive")) {
                    this.setPersistent(true);
                }
                ++n;
            }
        }
    }

    private void handleKeepAlive(String option) {
        Integer timeoutSec = null;
        timeoutSec = option.toUpperCase().startsWith("TIMEOUT=") ? Integer.valueOf(Integer.parseInt(option.substring("TIMEOUT=".length(), option.length()))) : Integer.valueOf(Integer.parseInt(option));
        if (timeoutSec != null && this.getBodyDataReceiveTimeoutMillis() == Long.MAX_VALUE) {
            this.setBodyDataReceiveTimeoutMillis((long)timeoutSec.intValue() * 1000L);
        }
    }

    private BodyDataSink sendResponseHeader(IHttpResponseHeader header, boolean autocompress) throws IOException {
        try {
            BodyDataSink bodyDataSink;
            this.enhanceResponseHeader(header);
            if (autocompress) {
                int length = header.getContentLength();
                if (length != -1) {
                    header.removeHeader("Content-Length");
                    header.setHeader("Transfer-Encoding", "chunked");
                }
                bodyDataSink = this.writeMessage(this.autocompressThresholdBytes, header);
                if (length != -1) {
                    HttpServerConnection.setAutocompressThreshold(bodyDataSink, 0);
                }
            } else {
                bodyDataSink = this.writeMessage(Integer.MAX_VALUE, header);
            }
            if (!this.isPersistent()) {
                this.setBodyCloseListener(bodyDataSink, this.connectionCloser);
            }
            return bodyDataSink;
        }
        catch (IOException ioe) {
            this.destroy();
            throw ioe;
        }
    }

    private BodyDataSink sendResponseHeader(IHttpResponseHeader header, int contentLength, boolean autocompress) throws IOException {
        try {
            BodyDataSink bodyDataSink;
            this.enhanceResponseHeader(header);
            if (autocompress && contentLength > this.autocompressThresholdBytes) {
                header.removeHeader("Content-Length");
                header.setHeader("Transfer-Encoding", "chunked");
                bodyDataSink = this.writeMessage(0, header);
            } else {
                bodyDataSink = this.writeMessage(header, contentLength);
            }
            if (!this.isPersistent()) {
                this.setBodyCloseListener(bodyDataSink, this.connectionCloser);
            }
            return bodyDataSink;
        }
        catch (IOException ioe) {
            this.destroy();
            throw ioe;
        }
    }

    private BodyDataSink sendResponseMessage(IHttpResponse response, boolean autocompress) throws IOException {
        IHttpResponseHeader responseHeader;
        block11: {
            try {
                responseHeader = response.getResponseHeader();
                if (response.getStatus() != 100) break block11;
                this.writeMessageSilence(response);
                return null;
            }
            catch (IOException ioe) {
                this.destroy();
                throw ioe;
            }
        }
        this.enhanceResponseHeader(responseHeader);
        if (response.hasBody()) {
            if (response.getNonBlockingBody().getDataHandler() != null) {
                LOG.warning("[" + this.getId() + "] a body handler is already assigned to the message body. current body handler will be removed");
            }
            if (autocompress) {
                response.removeHeader("Content-Length");
                response.setHeader("Transfer-Encoding", "chunked");
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] sending: " + response.getResponseHeader());
                }
                return this.writeMessage(this.autocompressThresholdBytes, response);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] sending: " + response.getResponseHeader());
            }
            return this.writeMessage(Integer.MAX_VALUE, response);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] sending (bodyless): " + response.getResponseHeader());
        }
        if (response.getContentLength() == -1 && response.getStatus() != 100 && response.getStatus() != 101) {
            response.setContentLength(0);
        }
        BodyDataSink bodyDataSink = this.writeMessage(responseHeader, 0);
        bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
        bodyDataSink.close();
        if (!this.isPersistent()) {
            this.closeQuitly();
        }
        return null;
    }

    private void enhanceResponseHeader(IHttpResponseHeader header) {
        if (header.getStatus() > 199) {
            String connectionHeader;
            String server = header.getServer();
            if (server == null) {
                header.setServer(ServerUtils.getComponentInfo());
            }
            if (header.getProtocol().equalsIgnoreCase("HTTP/1.0")) {
                this.setPersistent(false);
            }
            int remainingTransactions = 0;
            if (this.maxTransactions != null && (remainingTransactions = this.maxTransactions - this.getCountMessagesReceived()) <= 0) {
                this.setPersistent(false);
            }
            if (header.getStatus() >= 400 && this.isCloseOnSendingError) {
                this.setPersistent(false);
            }
            if (this.isPersistent() && header.getHeader("Connection") == null && (this.maxTransactions != null || this.requestTimeoutMillis != null)) {
                header.setHeader("Connection", "Keep-Alive");
                String keepAliveValue = null;
                if (this.maxTransactions != null) {
                    keepAliveValue = "max=" + remainingTransactions;
                }
                if (this.requestTimeoutMillis != null) {
                    keepAliveValue = keepAliveValue == null ? "timeout=" + this.requestTimeoutMillis / 1000L : String.valueOf(keepAliveValue) + ", timeout=" + this.requestTimeoutMillis / 1000L;
                }
                header.setHeader("Keep-Alive", keepAliveValue);
            }
            if ((connectionHeader = header.getHeader("Connection")) != null && connectionHeader.equalsIgnoreCase("close")) {
                this.setPersistent(false);
            } else if (!this.isPersistent()) {
                header.setHeader("Connection", "close");
                header.removeHeader("Keep-Alive");
            }
        }
    }

    private HttpSession getSession(IHttpRequest request) throws IOException {
        HttpSession session = null;
        if (this.useCookies) {
            List<String> cookieHeaders = request.getHeaderList("Cookie");
            for (String cookieHeader : cookieHeaders) {
                String[] cookies;
                String[] stringArray = cookies = cookieHeader.split(";");
                int n = cookies.length;
                int n2 = 0;
                while (n2 < n) {
                    String sessionId;
                    String name;
                    String cookie = stringArray[n2];
                    int idx = (cookie = cookie.trim()).indexOf("=");
                    if (idx != -1 && (name = cookie.substring(0, idx)).equals("JSESSIONID") && (session = this.sessionManager.getSession(sessionId = cookie.substring(idx + 1, cookie.length()).trim())) != null) {
                        return session;
                    }
                    ++n2;
                }
            }
        } else {
            String sessionToken = request.getMatrixParameter("jsessionid");
            if (sessionToken != null) {
                request.removeMatrixParameter("jsessionid");
                session = this.sessionManager.getSession(sessionToken);
                if (session != null) {
                    return session;
                }
            }
        }
        return null;
    }

    private boolean isLargerOrEquals(String protocolVersion, String otherProtocolVersion) {
        int minorOther;
        int minor;
        block7: {
            block6: {
                int majorOther;
                int major;
                block5: {
                    try {
                        int idx = protocolVersion.indexOf(".");
                        major = Integer.parseInt(protocolVersion.substring(0, idx));
                        minor = Integer.parseInt(protocolVersion.substring(idx + 1, protocolVersion.length()));
                        int idxOther = otherProtocolVersion.indexOf(".");
                        majorOther = Integer.parseInt(otherProtocolVersion.substring(0, idxOther));
                        minorOther = Integer.parseInt(otherProtocolVersion.substring(idxOther + 1, otherProtocolVersion.length()));
                        if (major <= majorOther) break block5;
                        return true;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("[" + this.getId() + "] error occured by comparing protocol version " + protocolVersion + " and " + otherProtocolVersion);
                    }
                }
                if (major >= majorOther) break block6;
                return false;
            }
            if (minor <= minorOther) break block7;
            return true;
        }
        return minor >= minorOther;
    }

    private boolean isContentTypeFormUrlencoded(IHttpMessage message) {
        if (!message.hasBody()) {
            return false;
        }
        String contentType = message.getContentType();
        return contentType != null && contentType.startsWith("application/x-www-form-urlencoded");
    }

    static final class AutoUpgradeHandler
    implements IUpgradeHandler {
        private final IUpgradeHandler successor;

        public AutoUpgradeHandler(IUpgradeHandler successor) {
            this.successor = successor;
        }

        @Override
        public boolean onRequest(IHttpExchange exchange) throws IOException, BadMessageException {
            IHttpRequest request = exchange.getRequest();
            HttpServerConnection httpCon = (HttpServerConnection)exchange.getConnection();
            if (httpCon.isAutohandleUpgadeHeader) {
                String upgrade = request.getRequestHeader().getHeader("Upgrade");
                if (upgrade != null && upgrade.equalsIgnoreCase("TLS/1.0")) {
                    if (httpCon.getUnderlyingTcpConnection().isSecuredModeActivateable()) {
                        httpCon.suspendReceiving();
                        HttpResponse response = new HttpResponse(101);
                        response.setHeader("Connection", "Upgrade");
                        response.setHeader("Upgrade", "TLS/1.0, HTTP/1.1");
                        exchange.send(response);
                        httpCon.getUnderlyingTcpConnection().activateSecuredMode();
                        httpCon.resumeReceiving();
                    } else {
                        exchange.send(new HttpResponse(400, "text/html", HttpServerConnection.generateErrorMessageHtml(400, "upgrade TLS is not supported", httpCon.getId())));
                    }
                    return true;
                }
                if (this.successor != null) {
                    return this.successor.onRequest(exchange);
                }
            }
            return false;
        }
    }

    private final class ConnectionCloser
    implements Runnable {
        private ConnectionCloser() {
        }

        @Override
        public void run() {
            HttpServerConnection.this.closeQuitly();
        }
    }

    private static final class DoNothingMessageHandler
    implements AbstractHttpConnection.IMessageHandler {
        private DoNothingMessageHandler() {
        }

        @Override
        public void onHeaderProcessed() throws IOException {
        }

        @Override
        public void onMessageReceived() throws IOException {
        }

        @Override
        public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
        }
    }

    @Execution(value=0)
    private static final class ForwardingResponseHandler
    implements IHttpResponseHandler {
        private IHttpExchange exchange = null;

        public ForwardingResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        @Override
        public void onException(IOException ioe) throws IOException {
            this.exchange.sendError(ioe);
        }
    }

    private final class InvokeOnMessageReceivedMessageHandler
    implements AbstractHttpConnection.IMessageHandler {
        private final MessageHeaderHandler headerHandler;
        private final ServerExchange exchange;

        public InvokeOnMessageReceivedMessageHandler(MessageHeaderHandler headerHandler, ServerExchange exchange) {
            this.headerHandler = headerHandler;
            this.exchange = exchange;
        }

        @Override
        public void onHeaderProcessed() throws IOException {
        }

        @Override
        public void onMessageReceived() throws IOException {
            if (HttpServerConnection.this.transactionMonitor != null) {
                HttpServerConnection.this.transactionMonitor.registerMessageReceived(HttpServerConnection.this, this.exchange.getRequest());
            }
            this.exchange.perform();
        }

        @Override
        public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
            if (HttpServerConnection.this.transactionMonitor != null) {
                HttpServerConnection.this.transactionMonitor.registerMessageReceivedException(HttpServerConnection.this, this.exchange.getRequest(), ioe);
            }
            this.headerHandler.onHeaderException(ioe, rawData);
        }
    }

    private final class MessageHeaderHandler
    implements AbstractHttpConnection.IMessageHeaderHandler {
        private MessageHeaderHandler() {
        }

        @Override
        public IHttpMessageHeader getAssociatedHeader() {
            return null;
        }

        @Override
        public AbstractHttpConnection.IMessageHandler onMessageHeaderReceived(IHttpMessage message) throws IOException {
            final IHttpRequest request = (IHttpRequest)message;
            if (HttpServerConnection.this.transactionMonitor != null) {
                HttpServerConnection.this.transactionMonitor.registerMessageHeaderReceived(HttpServerConnection.this, request.getRequestHeader());
            }
            HttpServerConnection.this.handleLifeCycleHeaders(request);
            if (LOG.isLoggable(Level.FINE)) {
                if (request.hasBody()) {
                    String body = "";
                    String contentType = request.getContentType();
                    if (contentType != null && contentType.startsWith("application/x-www-form-urlencode")) {
                        body = String.valueOf(request.getNonBlockingBody().toString()) + "\n";
                    }
                    LOG.fine("[" + HttpServerConnection.this.getId() + "] request received  from " + HttpServerConnection.this.getRemoteAddress() + ":" + HttpServerConnection.this.getRemotePort() + " (" + HttpServerConnection.this.getCountMessagesReceived() + ". request) " + request.getRequestHeader().toString() + body);
                } else {
                    LOG.fine("[" + HttpServerConnection.this.getId() + "] bodyless request received from " + HttpServerConnection.this.getRemoteAddress() + ":" + HttpServerConnection.this.getRemotePort() + " (" + HttpServerConnection.this.getCountMessagesReceived() + ". request) " + request.getRequestHeader().toString());
                }
            }
            boolean isFormUrlEncoded = HttpServerConnection.this.isContentTypeFormUrlencoded(request);
            if (message.hasBody()) {
                ServerExchange exchange;
                if (HttpUtils.isContainExpect100ContinueHeader(request.getRequestHeader()) && (isFormUrlEncoded || HttpServerConnection.this.requestHandlerAdapter.isInvokeOnMessageReceived())) {
                    if (LOG.isLoggable(Level.FINE)) {
                        if (HttpServerConnection.this.requestHandlerAdapter.isInvokeOnMessageReceived()) {
                            LOG.fine("request handler (chain) will be invoked onMessageReceived -> autohandle 100-continue");
                        } else if (isFormUrlEncoded) {
                            LOG.fine("request contains FormUrlEncoded body -> autohandle 100-continue");
                        }
                    }
                    request.setAttribute("org.xlightweb.100-continue-has-been-sent", "true");
                    HttpServerConnection.this.writeMessageSilence(new HttpResponse(100));
                    return DO_NOTHING_HANDLER;
                }
                if (HttpServerConnection.this.getBodyDataReceiveTimeoutMillis() != Long.MAX_VALUE) {
                    message.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(HttpServerConnection.this.getBodyDataReceiveTimeoutMillis());
                }
                if (isFormUrlEncoded) {
                    exchange = new ServerExchange(HttpServerConnection.this, HttpServerConnection.newFormEncodedRequestWrapper(request));
                    return new InvokeOnMessageReceivedMessageHandler(this, exchange);
                }
                if (HttpServerConnection.this.requestHandlerAdapter.isInvokeOnMessageReceived()) {
                    exchange = new ServerExchange(HttpServerConnection.this, request);
                    return new InvokeOnMessageReceivedMessageHandler(this, exchange);
                }
            }
            return new AbstractHttpConnection.IMessageHandler(){

                @Override
                public void onHeaderProcessed() throws IOException {
                    ServerExchange exchange = new ServerExchange(HttpServerConnection.this, request);
                    exchange.perform();
                }

                @Override
                public void onMessageReceived() throws IOException {
                    if (HttpServerConnection.this.transactionMonitor != null) {
                        HttpServerConnection.this.transactionMonitor.registerMessageReceived(HttpServerConnection.this, request);
                    }
                }

                @Override
                public void onBodyException(IOException ioe, ByteBuffer[] rawData) {
                    if (HttpServerConnection.this.transactionMonitor != null) {
                        HttpServerConnection.this.transactionMonitor.registerMessageReceivedException(HttpServerConnection.this, request, ioe);
                    }
                }
            };
        }

        @Override
        public void onHeaderException(IOException ioe, ByteBuffer[] rawData) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + HttpServerConnection.this.getId() + "] error occured by receiving request header " + ioe.toString());
            }
            HttpServerConnection.this.destroy();
        }
    }

    private class ServerExchange
    extends AbstractHttpConnection.AbstractExchange {
        private final IHttpRequest request;
        private HttpSession session;
        private boolean isSessionCreated;

        protected ServerExchange(HttpServerConnection httpCon, IHttpRequest request) throws IOException {
            super(null, httpCon);
            this.session = null;
            this.isSessionCreated = false;
            this.request = request;
            if (HttpUtils.isContainExpect100ContinueHeader(request.getRequestHeader()) || request.getHeader("Connection") != null && request.getHeader("Connection").equalsIgnoreCase("Upgrade")) {
                HttpServerConnection.this.isCloseOnSendingError = true;
            }
            if (!HttpServerConnection.this.sessionManager.isEmtpy()) {
                this.resolveSession();
            }
        }

        void perform() throws BadMessageException, IOException {
            boolean isUpgrade;
            String upgrade = this.request.getRequestHeader().getHeader("Upgrade");
            if (upgrade != null && (isUpgrade = HttpServerConnection.this.upgradeHandler.onRequest(this))) {
                return;
            }
            HttpServerConnection.this.requestHandlerAdapter.onRequest(this);
        }

        @Override
        public IHttpSession getSession(boolean create) {
            this.resolveSession();
            if (this.session != null) {
                return this.session;
            }
            if (create) {
                this.isSessionCreated = true;
                try {
                    int prefix = this.request.getContextPath().hashCode();
                    this.session = HttpServerConnection.this.sessionManager.getSession(HttpServerConnection.this.sessionManager.newSession(Integer.toHexString(prefix)));
                    this.session.setMaxInactiveInterval(HttpServerConnection.this.sessionMaxInactiveIntervalSec);
                    return this.session;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.toString());
                }
            }
            return null;
        }

        @Override
        public String encodeURL(String url) {
            if (HttpServerConnection.this.useCookies) {
                return url;
            }
            int pos = url.indexOf(63);
            if (pos == -1) {
                pos = url.indexOf(35);
            }
            if (pos == -1) {
                return String.valueOf(url) + ";jsessionid=" + this.session.getId();
            }
            return String.valueOf(url.substring(0, pos)) + ";jsessionid=" + this.session.getId() + url.substring(pos);
        }

        private void resolveSession() {
            block6: {
                if (this.session != null) {
                    return;
                }
                try {
                    this.session = HttpServerConnection.this.getSession(this.request);
                    if (this.session != null) {
                        String idPrefix = Integer.toHexString(this.request.getContextPath().hashCode());
                        if (this.session.getId().startsWith(idPrefix)) {
                            this.session.setLastAccessTime(System.currentTimeMillis());
                        } else {
                            this.session = null;
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block6;
                    LOG.fine("[" + this.getId() + "] error occured by resolving session " + ioe.toString());
                }
            }
        }

        @Override
        public final IHttpRequest getRequest() {
            return this.request;
        }

        private boolean isResponseCompressable(IHttpResponseHeader header) {
            return HttpServerConnection.this.autocompressThresholdBytes != Integer.MAX_VALUE && HttpUtils.isAcceptEncdoingGzip(this.request.getRequestHeader()) && header.getProtocolVersion().equals("1.1") && (header.getStatus() == 200 || header.getStatus() == 201 || header.getStatus() == 206) && HttpUtils.isCompressableMimeType(header.getContentType()) && header.getHeader("Content-Encoding") == null;
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header) throws IOException {
            this.ensureResponseHasNotBeenCommitted();
            this.handleCookieOnSend(header);
            if (header.getContentLength() == -1) {
                HttpResponseHeader newHeader;
                if (header.getProtocolVersion().equalsIgnoreCase("0.9") || header.getProtocolVersion().equalsIgnoreCase("1.0")) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] response is " + header.getProtocolVersion() + " version");
                    }
                    newHeader = header.getProtocolVersion().equalsIgnoreCase("0.9") ? new HttpResponseHeader(200) : new HttpResponseHeader(header.getStatus());
                    newHeader.copyHeaderFrom(header, new String[0]);
                    header = newHeader;
                }
                if (HttpUtils.hasContentType(header, "text/event-stream")) {
                    header.setHeader("Connection", "close");
                    HttpUtils.setExpireHeaders(header, 0);
                } else if (!HttpServerConnection.isAcceptingChunkedResponseBody(this.getRequest())) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] the requestor does not support chunked response messages (request protocol: " + this.getRequest().getProtocol() + "). Converting chunked response into simple response.");
                    }
                    newHeader = new HttpResponseHeader(header.getStatus(), header.getReason());
                    newHeader.copyHeaderFrom(header, new String[0]);
                    newHeader.setProtocol(this.getRequest().getProtocol());
                    newHeader.setHeader("Connection", "close");
                    header = newHeader;
                } else {
                    header.setTransferEncoding("chunked");
                }
            }
            this.setResponseCommited(true);
            BodyDataSink bodyDataSink = HttpServerConnection.this.sendResponseHeader(header, this.isResponseCompressable(header));
            if (HttpServerConnection.this.transactionMonitor != null) {
                HttpServerConnection.this.transactionMonitor.registerMessageHeaderSent(this.request, header, bodyDataSink);
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        HttpServerConnection.this.transactionMonitor.registerMessageSent(ServerExchange.this.request);
                    }
                };
                HttpServerConnection.this.setBodyCloseListener(bodyDataSink, task);
            }
            return bodyDataSink;
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException {
            this.ensureResponseHasNotBeenCommitted();
            this.handleCookieOnSend(header);
            header.setContentLength(contentLength);
            try {
                if (!this.getRequest().getProtocolVersion().equals(header.getProtocolVersion()) && HttpServerConnection.this.isLargerOrEquals(header.getProtocolVersion(), this.getRequest().getRequestHeader().getProtocolVersion())) {
                    header.setHeader("Connection", "close");
                    header.setProtocol(this.getRequest().getProtocol());
                }
            }
            catch (Exception e) {
                HttpResponse errorResponse = null;
                errorResponse = HttpUtils.isShowDetailedError() ? new HttpResponse(400, "text/html", HttpServerConnection.generateErrorMessageHtml(400, DataConverter.toString(e), this.getId())) : new HttpResponse(400, "text/html", HttpServerConnection.generateErrorMessageHtml(400, HttpUtils.getReason(400), this.getId()));
                this.setResponseCommited(true);
                HttpServerConnection.this.sendResponseMessage(errorResponse, false);
                throw new IOException(e.toString());
            }
            this.setResponseCommited(true);
            BodyDataSink bodyDataSink = HttpServerConnection.this.sendResponseHeader(header, contentLength, this.isResponseCompressable(header));
            if (HttpServerConnection.this.transactionMonitor != null) {
                HttpServerConnection.this.transactionMonitor.registerMessageHeaderSent(this.request, header, bodyDataSink);
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        HttpServerConnection.this.transactionMonitor.registerMessageSent(ServerExchange.this.request);
                    }
                };
                HttpServerConnection.this.setBodyCloseListener(bodyDataSink, task);
            }
            return bodyDataSink;
        }

        @Override
        protected void doSendContinue() throws IOException {
            HttpServerConnection.this.writeMessageSilence(new HttpResponse(100));
        }

        @Override
        public void send(IHttpResponse response) throws IOException {
            if (response.hasBody() && HttpServerConnection.isForwardable(response.getNonBlockingBody())) {
                BodyDataSink dataSink = this.send(response.getResponseHeader());
                HttpServerConnection.forwardBody(response.getNonBlockingBody(), dataSink);
                return;
            }
            this.ensureResponseHasNotBeenCommitted();
            this.handleCookieOnSend(response.getResponseHeader());
            try {
                if (!response.getProtocolVersion().equals(this.getRequest().getProtocolVersion())) {
                    if (response.getProtocolVersion().equals("0.9") && response.getContentLength() == -1) {
                        HttpResponseHeader header = new HttpResponseHeader(200);
                        header.copyHeaderFrom(response.getResponseHeader(), new String[0]);
                        header.setProtocol(this.getRequest().getProtocol());
                        header.setHeader("Connection", "close");
                        BodyDataSink bodyDataSink = HttpServerConnection.this.sendResponseHeader(header, false);
                        NonBlockingBodyDataSource bodyDataSource = response.getNonBlockingBody();
                        BodyForwarder forwarder = new BodyForwarder(bodyDataSource, bodyDataSink);
                        bodyDataSource.setDataHandler(forwarder);
                        return;
                    }
                    if (HttpServerConnection.this.isLargerOrEquals(response.getResponseHeader().getProtocolVersion(), this.getRequest().getRequestHeader().getProtocolVersion())) {
                        response.getResponseHeader().setProtocol(this.getRequest().getProtocol());
                        response.getResponseHeader().setHeader("Connection", "close");
                    }
                }
            }
            catch (Exception e) {
                HttpResponse errorResponse = null;
                errorResponse = HttpUtils.isShowDetailedError() ? new HttpResponse(400, "text/html", HttpServerConnection.generateErrorMessageHtml(400, DataConverter.toString(e), this.getId())) : new HttpResponse(400, "text/html", HttpServerConnection.generateErrorMessageHtml(400, HttpUtils.getReason(400), this.getId()));
                this.setResponseCommited(true);
                HttpServerConnection.this.sendResponseMessage(errorResponse, false);
                throw new IOException(e.toString());
            }
            if (response.getStatus() != 100) {
                this.setResponseCommited(true);
            }
            this.addLengthHeaderIfRequired(response);
            BodyDataSink dataSink = HttpServerConnection.this.sendResponseMessage(response, this.isResponseCompressable(response.getResponseHeader()));
            if (HttpServerConnection.this.transactionMonitor != null) {
                HttpServerConnection.this.transactionMonitor.registerMessageHeaderSent(this.request, response.getResponseHeader(), dataSink);
                if (response.hasBody()) {
                    BodyListener bodyListener = new BodyListener();
                    NonBlockingBodyDataSource ds = response.getNonBlockingBody();
                    ds.addCompleteListener(bodyListener);
                    ds.addDestroyListener(bodyListener);
                } else {
                    HttpServerConnection.this.transactionMonitor.registerMessageSent(this.request);
                }
            }
        }

        private void addLengthHeaderIfRequired(IHttpResponse response) throws IOException {
            if (!response.hasBody() && !HttpUtils.isBodylessStatus(response.getStatus())) {
                if (response.getContentLength() == -1) {
                    response.setContentLength(0);
                }
                response.removeHeader("Transfer-Encoding");
            }
        }

        private void handleCookieOnSend(IHttpResponseHeader header) {
            if (header.getStatus() != 100) {
                block7: {
                    if (this.session != null) {
                        try {
                            HttpServerConnection.this.sessionManager.saveSession(this.session.getId());
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block7;
                            LOG.fine("[" + this.getId() + "] error occured by saving session " + this.session.getId());
                        }
                    }
                }
                if (this.isSessionCreated && HttpServerConnection.this.useCookies) {
                    StringBuilder sb = new StringBuilder("JSESSIONID=" + this.session.getId() + ";path=/");
                    if (IS_SESSION_COOKIE_HTTPONLY) {
                        sb.append(";HttpOnly");
                    }
                    if (HttpServerConnection.this.isSecure()) {
                        sb.append(";secure");
                    }
                    header.addHeader("Set-Cookie", sb.toString());
                }
            }
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new ForwardingResponseHandler(this);
            }
            BodyDataSink bodyDataSink = HttpServerConnection.this.newEmtpyBodyDataSink(requestHeader);
            HttpServerConnection.this.setBodyCloseListener(bodyDataSink, this.newCloseListener(responseHandler));
            return bodyDataSink;
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, contentLength, new ForwardingResponseHandler(this));
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new ForwardingResponseHandler(this);
            }
            BodyDataSink bodyDataSink = HttpServerConnection.this.newEmtpyBodyDataSink(requestHeader);
            HttpServerConnection.this.setBodyCloseListener(bodyDataSink, this.newCloseListener(responseHandler));
            return bodyDataSink;
        }

        private Runnable newCloseListener(final IHttpResponseHandler responseHandler) {
            return new Runnable(){

                @Override
                public void run() {
                    ServerExchange.this.sendNotHandledError(responseHandler);
                }
            };
        }

        @Override
        public void forward(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new ForwardingResponseHandler(this);
            }
            this.sendNotHandledError(responseHandler);
        }

        @Override
        public void forward(IHttpRequest request) throws IOException, ConnectException, IllegalStateException {
            this.forward(request, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        private void sendNotHandledError(IHttpResponseHandler responseHandler) {
            block3: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] no handler found (for requested resource). returning error message");
                }
                try {
                    HttpResponse response = new HttpResponse(404, "text/html", HttpServerConnection.generateErrorMessageHtml(404, null, this.getId()));
                    this.callResponseHandler(responseHandler, response);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("[" + this.getId() + "] could not send not handle response. " + ioe.toString());
                }
            }
        }

        @Override
        public void sendError(Exception e) {
            int code = 500;
            if (e instanceof BadMessageException) {
                code = ((BadMessageException)e).getStatus();
            } else if (e instanceof MaxConnectionsExceededException) {
                code = 503;
            }
            if (HttpUtils.isShowDetailedError()) {
                this.sendError(code, DataConverter.toString(e));
            } else if (e instanceof BadMessageException) {
                this.sendError(code, e.getMessage());
            } else {
                this.sendError(code);
            }
        }

        @Override
        public void sendError(int errorCode, String msg) {
            if (HttpServerConnection.this.isCloseOnSendingError || errorCode >= 500 && IS_CLOSE_CONNECTION_ON_5XX_RESPONSE) {
                HttpServerConnection.this.setPersistent(false);
            }
            if (this.isResponseCommitted()) {
                throw new IllegalStateException("response is already committed");
            }
            super.sendError(errorCode, msg);
        }

        private final class BodyListener
        implements IBodyCompleteListener,
        IBodyDestroyListener {
            private BodyListener() {
            }

            @Override
            @Execution(value=0)
            public void onComplete() throws IOException {
                HttpServerConnection.this.transactionMonitor.registerMessageSent(ServerExchange.this.request);
            }

            @Override
            public void onDestroyed() throws IOException {
                HttpServerConnection.this.transactionMonitor.registerMessageBodySentError(ServerExchange.this.request);
            }
        }
    }

    private static final class TimeoutWatchDogTask
    extends TimerTask
    implements Closeable {
        private WeakReference<HttpServerConnection> connectionRef = null;

        public TimeoutWatchDogTask(HttpServerConnection connection) {
            this.connectionRef = new WeakReference<HttpServerConnection>(connection);
        }

        @Override
        public void run() {
            WeakReference<HttpServerConnection> ref = this.connectionRef;
            if (ref != null) {
                HttpServerConnection connection = (HttpServerConnection)ref.get();
                if (connection == null) {
                    this.close();
                } else {
                    connection.checkRequestTimeout(System.currentTimeMillis());
                }
            }
        }

        @Override
        public void close() {
            this.cancel();
            this.connectionRef = null;
        }
    }
}

