/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xlightweb.IHttpSession;
import org.xsocket.DataConverter;

public final class HttpSession
implements IHttpSession,
Serializable {
    private static final long serialVersionUID = 3712677521662304844L;
    private final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    private final AtomicBoolean isValid = new AtomicBoolean(true);
    private final String id;
    private final long creationTime;
    private long lastAccesTime = this.creationTime = System.currentTimeMillis();
    private int maxInactiveIntervalSec = Integer.MAX_VALUE;
    private long changeVersion;

    HttpSession(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        if (!this.isValid()) {
            throw new IllegalStateException("Session " + this.getId() + " is invalid");
        }
        return this.lastAccesTime;
    }

    void setLastAccessTime(long lastAccesTime) {
        this.lastAccesTime = lastAccesTime;
        this.incChangeVersion();
    }

    @Override
    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException("Session " + this.getId() + " is invalid");
        }
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (!this.isValid()) {
            throw new IllegalStateException("Session " + this.getId() + " is invalid");
        }
        this.attributes.put(name, value);
        this.incChangeVersion();
    }

    @Override
    public void removeAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException("Session " + this.getId() + " is invalid");
        }
        this.attributes.remove(name);
        this.incChangeVersion();
    }

    @Override
    public void invalidate() {
        this.isValid.set(false);
        this.incChangeVersion();
    }

    @Override
    public boolean isValid() {
        if (this.isValid.get() && System.currentTimeMillis() > this.lastAccesTime + (long)this.maxInactiveIntervalSec * 1000L) {
            this.invalidate();
        }
        return this.isValid.get();
    }

    @Override
    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException("Session " + this.getId() + " is invalid");
        }
        return Collections.enumeration(this.getAttributeNameSet());
    }

    @Override
    public Set<String> getAttributeNameSet() {
        if (!this.isValid()) {
            throw new IllegalStateException("Session " + this.getId() + " is invalid");
        }
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public void setMaxInactiveInterval(int maxInactiveIntervalSec) {
        this.maxInactiveIntervalSec = maxInactiveIntervalSec;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveIntervalSec;
    }

    private void incChangeVersion() {
        ++this.changeVersion;
    }

    public long getChangeVersion() {
        return this.changeVersion;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder("created=" + DataConverter.toFormatedDate(this.creationTime) + ", lastAccess=" + DataConverter.toFormatedDate(this.lastAccesTime) + ", maxInactiveIntervalSec=" + this.maxInactiveIntervalSec + ",  Data: ");
            boolean isFrist = true;
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                sb.append(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                if (isFrist) {
                    isFrist = false;
                    continue;
                }
                sb.append("&");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "exception occured by performing toSting() " + e.toString();
        }
    }
}

