/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xlightweb.Context;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IWebHandler;
import org.xlightweb.RequestHandlerChain;
import org.xlightweb.server.HttpProtocolAdapter;
import org.xsocket.DataConverter;
import org.xsocket.IntrospectionBasedDynamicMBean;
import org.xsocket.Resource;
import org.xsocket.connection.IServer;

final class ServerUtils {
    private static final Logger LOG = Logger.getLogger(ServerUtils.class.getName());
    private static Map<String, String> mimeTypeMap;
    private static String componentInfo;

    private ServerUtils() {
    }

    static String getComponentInfo() {
        if (componentInfo == null) {
            componentInfo = "xLightweb/" + HttpUtils.getImplementationVersion();
        }
        return componentInfo;
    }

    static ObjectName exportMbean(MBeanServer mbeanServer, ObjectName objectname, Object handler) throws Exception {
        String namespace = objectname.getDomain();
        if (handler instanceof Context) {
            Context ctx = (Context)handler;
            objectname = new ObjectName(String.valueOf(namespace) + ":type=HttpContext" + ", name=[" + ctx.getContextPath() + "]");
            for (IWebHandler hdl : ctx.getHandlers()) {
                ServerUtils.exportMbean(mbeanServer, objectname, hdl);
            }
        } else if (handler instanceof RequestHandlerChain) {
            RequestHandlerChain chain = (RequestHandlerChain)handler;
            objectname = new ObjectName(String.valueOf(namespace) + ":type=HttpRequestHandlerChain" + ", name=" + chain.hashCode());
            for (IHttpRequestHandler hdl : chain.getHandlers()) {
                ServerUtils.exportMbean(mbeanServer, objectname, hdl);
            }
        } else {
            String name = handler.getClass().getSimpleName().trim();
            if (name.length() < 1) {
                name = Integer.toString(handler.hashCode());
            }
            objectname = new ObjectName(String.valueOf(namespace) + ":type=HttpRequestHandler, name=" + name);
        }
        mbeanServer.registerMBean(new IntrospectionBasedDynamicMBean(handler), objectname);
        return objectname;
    }

    static synchronized Map<String, String> getMimeTypeMapping() {
        if (mimeTypeMap == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            mimeTypeMap = Collections.unmodifiableMap(map);
            InputStreamReader isr = null;
            BufferedReader lnr = null;
            try {
                try {
                    isr = new InputStreamReader(ServerUtils.class.getResourceAsStream("/org/xsocket/connection/http/server/mime.types"));
                    lnr = new LineNumberReader(isr);
                    String line = null;
                    do {
                        if ((line = ((LineNumberReader)lnr).readLine()) == null || (line = line.trim()).startsWith("#")) continue;
                        StringTokenizer st = new StringTokenizer(line);
                        if (st.hasMoreTokens()) {
                            String mimeType = st.nextToken();
                            while (st.hasMoreTokens()) {
                                String extension = st.nextToken();
                                map.put(extension, mimeType);
                                if (!LOG.isLoggable(Level.FINER)) continue;
                                LOG.finer("mapping " + extension + " -> " + mimeType + " added");
                            }
                        } else {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("line " + line + "ignored");
                        }
                    } while (line != null);
                    lnr.close();
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Error occured by reding version file " + ioe.toString());
                    }
                    try {
                        if (lnr != null) {
                            lnr.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("exception occured by closing version.txt file stream " + ioe2.toString());
                        }
                    }
                }
            }
            finally {
                block23: {
                    try {
                        if (lnr != null) {
                            lnr.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block23;
                        LOG.fine("exception occured by closing version.txt file stream " + ioe.toString());
                    }
                }
            }
        }
        return mimeTypeMap;
    }

    static void injectServerField(Object handler, IServer server) {
        Field[] fields;
        Field[] fieldArray = fields = handler.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(Resource.class)) {
                Resource res = field.getAnnotation(Resource.class);
                if (field.getType() == IServer.class || res.type() == IServer.class) {
                    field.setAccessible(true);
                    try {
                        field.set(handler, server);
                    }
                    catch (IllegalAccessException iae) {
                        LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + DataConverter.toString(iae));
                    }
                }
            }
            ++n2;
        }
    }

    static void injectProtocolAdapter(Object handler, HttpProtocolAdapter adapter) {
        Field[] fields;
        Field[] fieldArray = fields = handler.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(Resource.class)) {
                Resource res = field.getAnnotation(Resource.class);
                if (field.getType() == HttpProtocolAdapter.class || res.type() == HttpProtocolAdapter.class) {
                    field.setAccessible(true);
                    try {
                        field.set(handler, adapter);
                    }
                    catch (IllegalAccessException iae) {
                        LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + DataConverter.toString(iae));
                    }
                }
            }
            ++n2;
        }
    }
}

