/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.server.HttpServerConnection;
import org.xsocket.DataConverter;

final class TransactionMonitor {
    private static final Logger LOG = Logger.getLogger(TransactionMonitor.class.getName());
    private final Map<IHttpRequestHeader, Transaction> pendingTransactions = new HashMap<IHttpRequestHeader, Transaction>();
    private final TransactionLog transactionLog;

    public TransactionMonitor(TransactionLog transactionLog) {
        this.transactionLog = transactionLog;
    }

    public void registerMessageHeaderReceived(HttpServerConnection con, IHttpRequestHeader requestHeader) {
        Transaction transaction = new Transaction();
        transaction.registerMessageHeaderReceived(con, requestHeader);
        this.pendingTransactions.put(requestHeader, transaction);
        this.transactionLog.add(transaction);
    }

    public void registerMessageReceived(HttpServerConnection con, IHttpRequest request) {
        Transaction transaction = this.pendingTransactions.get(request.getRequestHeader());
        if (transaction != null) {
            transaction.registerMessageReceived(con, request);
        }
    }

    public void registerMessageReceivedException(HttpServerConnection con, IHttpRequest request, IOException ioe) {
        Transaction transaction = this.pendingTransactions.get(request.getRequestHeader());
        if (transaction != null) {
            transaction.registerMessageExceptionReceived(con, request, ioe);
        }
    }

    public void registerMessageHeaderSent(IHttpRequest request, IHttpResponseHeader responseHeader, BodyDataSink body) {
        Transaction transaction = this.pendingTransactions.get(request.getRequestHeader());
        if (transaction != null) {
            transaction.registerMessageHeaderSent(request, responseHeader, body);
        }
    }

    public void registerMessageSent(IHttpRequest request) {
        Transaction transaction = this.pendingTransactions.remove(request.getRequestHeader());
        if (transaction != null) {
            transaction.registerMessageSent(request);
        }
    }

    public void registerMessageBodySentError(IHttpRequest request) {
        Transaction transaction = this.pendingTransactions.remove(request.getRequestHeader());
        if (transaction != null) {
            transaction.registerMessageBodySentError(request);
        }
    }

    int getPendingTransactions() {
        return this.pendingTransactions.size();
    }

    static final class Transaction {
        private static final int WAITING_FOR_REQUEST_BODY = 1;
        private static final int WAITING_FOR_RESPONSE_HEADER = 5;
        private static final int WAITING_FOR_RESPONSE_BODY = 9;
        private static final int COMPLETE = 15;
        private int state = 1;
        private long startDate = 0L;
        private long endDate = 0L;
        private boolean isErrorOccuredBySendingBody = false;
        private String requestHeaderInfo = "";
        private NonBlockingBodyDataSource requestBody = null;
        private String responseHeaderInfo = "";
        private BodyDataSink responseBody = null;
        private String conInfo = "";
        private SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

        Transaction() {
        }

        public void registerMessageHeaderReceived(HttpServerConnection con, IHttpRequestHeader requestHeader) {
            this.startDate = System.currentTimeMillis();
            this.conInfo = "id=" + con.getId();
            this.requestHeaderInfo = requestHeader.getQueryString() != null ? "[" + this.df.format(new Date()) + "] " + con.getUnderlyingTcpConnection().getRemoteAddress() + ":" + con.getUnderlyingTcpConnection().getRemotePort() + " " + requestHeader.getMethod() + " " + requestHeader.getRequestURI() + requestHeader.getQueryString() : "[" + this.df.format(new Date()) + "] " + con.getUnderlyingTcpConnection().getRemoteAddress() + ":" + con.getUnderlyingTcpConnection().getRemotePort() + " " + requestHeader.getMethod() + " " + requestHeader.getRequestURI();
        }

        public void registerMessageReceived(HttpServerConnection con, IHttpRequest request) {
            block3: {
                this.state = 5;
                if (request.hasBody()) {
                    try {
                        this.requestBody = request.getNonBlockingBody();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by getting body " + ioe.toString());
                    }
                }
            }
        }

        public void registerMessageExceptionReceived(HttpServerConnection con, IHttpRequest request, IOException ioe) {
            this.state = 5;
        }

        public void registerMessageHeaderSent(IHttpRequest request, IHttpResponseHeader responseHeader, BodyDataSink responseBody) {
            this.state = 9;
            this.responseHeaderInfo = String.valueOf(responseHeader.getStatus()) + " " + responseHeader.getReason();
            this.responseBody = responseBody;
        }

        public void registerMessageSent(IHttpRequest request) {
            this.endDate = System.currentTimeMillis();
            this.state = 15;
        }

        public void registerMessageBodySentError(IHttpRequest request) {
            this.endDate = System.currentTimeMillis();
            this.state = 15;
            this.isErrorOccuredBySendingBody = true;
        }

        private String getRequestBodyInfo() {
            if (this.requestBody == null) {
                return "NO BODY";
            }
            if (this.state == 9) {
                return String.valueOf(this.requestBody.getClass().getSimpleName()) + "/currentSize " + HttpServerConnection.getSizeDataReceived(this.requestBody);
            }
            return String.valueOf(this.requestBody.getClass().getSimpleName()) + "/totalSize " + HttpServerConnection.getSizeDataReceived(this.requestBody);
        }

        private String getResponseBodyInfo() {
            if (this.responseBody == null) {
                return "NO BODY";
            }
            if (this.state == 9) {
                return String.valueOf(this.responseBody.getClass().getSimpleName()) + "/currentSize " + HttpServerConnection.getSizeWritten(this.responseBody);
            }
            return String.valueOf(this.responseBody.getClass().getSimpleName()) + "/totalSize " + HttpServerConnection.getSizeWritten(this.responseBody);
        }

        public String toString() {
            switch (this.state) {
                case 1: {
                    String elapsed = "elapsed=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.startDate);
                    return String.valueOf(this.requestHeaderInfo) + " (" + this.getRequestBodyInfo() + ") -> " + " [WAITING for REQUEST BODY " + elapsed + " " + this.conInfo + "]";
                }
                case 5: {
                    String elapsed = "elapsed=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.startDate);
                    return String.valueOf(this.requestHeaderInfo) + " (" + this.getRequestBodyInfo() + ") -> [WAITING for RESPONSE HEADER " + elapsed + " " + this.conInfo + "]";
                }
                case 9: {
                    String elapsed = "elapsed=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.startDate);
                    return String.valueOf(this.requestHeaderInfo) + " (" + this.getRequestBodyInfo() + ") -> " + this.responseHeaderInfo + " (" + this.getResponseBodyInfo() + ") [WAITING for RESPONSE BODY " + elapsed + " " + this.conInfo + "]";
                }
            }
            String elapsed = "elapsed=" + DataConverter.toFormatedDuration(this.endDate - this.startDate);
            if (this.isErrorOccuredBySendingBody) {
                return String.valueOf(this.requestHeaderInfo) + " (" + this.getRequestBodyInfo() + ") error occured by sending body -> " + this.responseHeaderInfo + " (" + this.getResponseBodyInfo() + ") [" + elapsed + " " + this.conInfo + "]";
            }
            return String.valueOf(this.requestHeaderInfo) + " (" + this.getRequestBodyInfo() + ") -> " + this.responseHeaderInfo + " (" + this.getResponseBodyInfo() + ") [" + elapsed + " " + this.conInfo + "]";
        }
    }

    static final class TransactionLog {
        private final LinkedList<Transaction> transactions = new LinkedList();
        private int maxSize = 0;

        TransactionLog(int maxSize) {
            this.maxSize = maxSize;
        }

        void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            this.removeOddEntries();
        }

        int getMaxSize() {
            return this.maxSize;
        }

        void add(Transaction transaction) {
            this.transactions.add(transaction);
            this.removeOddEntries();
        }

        private void removeOddEntries() {
            while (this.transactions.size() > this.maxSize) {
                try {
                    this.transactions.removeFirst();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by removing list entry " + e.toString());
                }
            }
        }

        public List<Transaction> getTransactions() {
            return (List)this.transactions.clone();
        }
    }
}

