/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public final class IntrospectionBasedDynamicMBean
implements DynamicMBean {
    private static final Logger LOG = Logger.getLogger(IntrospectionBasedDynamicMBean.class.getName());
    private Object obj;
    private final Map<String, Info> properties = new HashMap<String, Info>();

    public IntrospectionBasedDynamicMBean(Object obj) {
        this.obj = obj;
    }

    @Override
    public Object getAttribute(String attribute) {
        String methodName = "get" + attribute;
        try {
            Method method = this.getMethod(this.obj.getClass(), methodName, new Class[0]);
            if (method == null) {
                methodName = "is" + attribute;
                method = this.getMethod(this.obj.getClass(), methodName, new Class[0]);
            }
            method.setAccessible(true);
            return method.invoke(this.obj, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured (InvocationTargetException) by accessing attribute " + attribute + ": " + ite.toString());
            }
            return null;
        }
        catch (IllegalAccessException iae) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured (IllegalAccessException) by accessing attribute " + attribute + ": " + iae.toString());
            }
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Method getMethod(Class clazz, String methodname, Class[] params) {
        do {
            try {
                method = clazz.getDeclaredMethod(methodname, params);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException method) {
                var7_8 = clazz.getInterfaces();
                var6_7 = var7_8.length;
                var5_6 = 0;
                ** while (var5_6 < var6_7)
            }
lbl-1000:
            // 1 sources

            {
                interf = var7_8[var5_6];
                this.getMethod(interf, methodname, params);
                ++var5_6;
                continue;
            }
lbl16:
            // 1 sources

        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            list.add(new Attribute(attribute, this.getAttribute(attribute)));
            ++n2;
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) {
        block4: {
            String methodName = "set" + attribute.getName();
            Info info = this.getInfo(attribute.getName());
            try {
                Method method = this.getMethod(this.obj.getClass(), methodName, new Class[]{info.propertyType});
                method.setAccessible(true);
                method.invoke(this.obj, attribute.getValue());
            }
            catch (InvocationTargetException ite) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured (InvocationTargetException) by setting attribute " + ite.toString());
                }
            }
            catch (IllegalAccessException iae) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("error occured (IllegalAccessException) by setting attribute " + iae.toString());
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        Attribute[] attrs;
        AttributeList result = new AttributeList();
        Attribute[] attributeArray = attrs = attributes.toArray(new Attribute[attributes.size()]);
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            this.setAttribute(attr);
            result.add(new Attribute(attr.getName(), attr.getValue()));
            ++n2;
        }
        return result;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        this.analyze(this.obj);
        String[] attributes = this.properties.keySet().toArray(new String[this.properties.size()]);
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attributes.length];
        int i = 0;
        while (i < attrs.length) {
            attrs[i] = this.properties.get(attributes[i]).asbMBeanAttributeInfo();
            ++i;
        }
        return new MBeanInfo(this.obj.getClass().getName(), "", attrs, null, null, null);
    }

    private void analyze(Object obj) {
        Class<?> clazz = obj.getClass();
        do {
            this.analyzeType(clazz);
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interf = classArray[n2];
                this.analyzeType(interf);
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    private void analyzeType(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            if (!Modifier.isPrivate(method.getModifiers())) {
                Info info;
                Class<?> propertyType;
                if (name.length() > 3 && name.startsWith("get") && method.getParameterTypes().length == 0 && this.isAcceptedPropertyType(propertyType = method.getReturnType())) {
                    info = this.getInfo(name.substring(3, name.length()));
                    info.isReadable = true;
                    info.propertyType = propertyType;
                }
                if (name.length() > 2 && name.startsWith("is") && method.getParameterTypes().length == 0 && this.isAcceptedPropertyType(propertyType = method.getReturnType())) {
                    info = this.getInfo(name.substring(2, name.length()));
                    info.isReadable = true;
                    info.propertyType = propertyType;
                }
                if (name.length() > 3 && name.startsWith("set") && method.getParameterTypes().length == 1 && this.isAcceptedPropertyType(propertyType = method.getParameterTypes()[0])) {
                    info = this.getInfo(name.substring(3, name.length()));
                    info.isWriteable = true;
                    info.propertyType = propertyType;
                }
            }
            ++n2;
        }
    }

    private Info getInfo(String name) {
        Info info = this.properties.get(name);
        if (info == null) {
            info = new Info();
            info.propertyName = name;
            info.propertyDescription = "Property " + info.propertyName;
            this.properties.put(name, info);
        }
        return info;
    }

    private boolean isAcceptedPropertyType(Class clazz) {
        if (clazz.isAssignableFrom(List.class)) {
            return true;
        }
        String name = clazz.getName();
        return name.equals("int") || name.equals("java.lang.Integer") || name.equals("long") || name.equals("java.lang.Long") || name.equals("double") || name.equals("java.lang.Double") || name.equals("boolean") || name.equals("java.lang.Boolean") || name.equals("float") || name.equals("java.lang.String") || name.equals("java.util.Date") || name.equals("java.lang.Float");
    }

    private static class Info {
        String propertyName = null;
        Class propertyType = null;
        String propertyDescription = null;
        boolean isReadable = false;
        boolean isWriteable = false;
        boolean isIs = false;

        private Info() {
        }

        MBeanAttributeInfo asbMBeanAttributeInfo() {
            return new MBeanAttributeInfo(this.propertyName, this.propertyType.getName(), this.propertyDescription, this.isReadable, this.isWriteable, this.isIs);
        }
    }
}

