/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SerializedTaskQueue {
    private static final Logger LOG = Logger.getLogger(SerializedTaskQueue.class.getName());
    private final LinkedList<Runnable> multithreadedTaskQueue = new LinkedList();
    private final ReentrantLock processLock = new ReentrantLock(false);
    private final MultithreadedTaskProcessor multithreadedTaskProcessor = new MultithreadedTaskProcessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performNonThreaded(Runnable task, Executor workerpool) {
        if (this.processLock.tryLock()) {
            try {
                LinkedList<Runnable> linkedList = this.multithreadedTaskQueue;
                synchronized (linkedList) {
                    if (!this.multithreadedTaskQueue.isEmpty()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("multithreaded tasks are in queue . register non threaded task " + task.toString() + " to multithreaded queue (non threaded task will be performed multithreaded)");
                        }
                        this.performMultiThreaded(task, workerpool);
                        return;
                    }
                }
                task.run();
                return;
            }
            finally {
                this.processLock.unlock();
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("a task is already running. register non threaded task " + task.toString() + " to perform it multithreaded");
        }
        this.performMultiThreaded(task, workerpool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMultiThreaded(Runnable task, Executor workerpool) {
        LinkedList<Runnable> linkedList = this.multithreadedTaskQueue;
        synchronized (linkedList) {
            if (this.multithreadedTaskQueue.isEmpty()) {
                this.multithreadedTaskQueue.addLast(task);
                try {
                    workerpool.execute(this.multithreadedTaskProcessor);
                }
                catch (RejectedExecutionException ree) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("task has been rejected by worker pool " + workerpool + " (worker pool cosed?) performing task by starting a new thread");
                    }
                    Thread t = new Thread((Runnable)this.multithreadedTaskProcessor, "SerializedTaskQueueFallbackThread");
                    t.setDaemon(true);
                    t.start();
                }
            } else {
                this.multithreadedTaskQueue.addLast(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performPendingTasks() {
        this.processLock.lock();
        try {
            while (true) {
                LinkedList<Runnable> linkedList;
                Runnable task;
                block17: {
                    task = null;
                    linkedList = this.multithreadedTaskQueue;
                    synchronized (linkedList) {
                        if (!this.multithreadedTaskQueue.isEmpty()) {
                            task = this.multithreadedTaskQueue.get(0);
                        }
                    }
                    if (task != null) {
                        try {
                            task.run();
                        }
                        catch (Throwable t) {
                            if (!LOG.isLoggable(Level.FINE)) break block17;
                            LOG.fine("error occured by processing " + task + " " + t.toString());
                        }
                    }
                }
                linkedList = this.multithreadedTaskQueue;
                synchronized (linkedList) {
                    this.multithreadedTaskQueue.remove(task);
                    if (this.multithreadedTaskQueue.isEmpty()) {
                        return;
                    }
                    {
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 7, 13] lbl34 : MonitorExitStatement: MONITOREXIT : var2_2
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.processLock.unlock();
        }
    }

    private final class MultithreadedTaskProcessor
    implements Runnable {
        private MultithreadedTaskProcessor() {
        }

        @Override
        public void run() {
            SerializedTaskQueue.this.performPendingTasks();
        }
    }
}

