/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.xsocket.IDataSink;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

public interface IBlockingConnection
extends IConnection,
IDataSource,
IDataSink,
GatheringByteChannel,
ReadableByteChannel,
WritableByteChannel,
Flushable {
    public static final int DEFAULT_READ_TIMEOUT = Integer.MAX_VALUE;

    public void setAutoflush(boolean var1);

    public boolean isAutoflush();

    @Override
    public void flush() throws ClosedChannelException, IOException, SocketTimeoutException;

    public void activateSecuredMode() throws IOException;

    public void deactivateSecuredMode() throws IOException;

    public boolean isSecure();

    public int getPendingWriteDataSize();

    public void setReadTimeoutMillis(int var1) throws IOException;

    public int getReadTimeoutMillis() throws IOException;

    public void suspendReceiving() throws IOException;

    public void resumeReceiving() throws IOException;

    public boolean isReceivingSuspended();

    public void unread(ByteBuffer[] var1) throws IOException;

    public void unread(ByteBuffer var1) throws IOException;

    public void unread(byte[] var1) throws IOException;

    public void unread(String var1) throws IOException;

    public boolean resetToWriteMark();

    public boolean resetToReadMark();

    public void markWritePosition();

    public void markReadPosition();

    public void removeReadMark();

    public void removeWriteMark();

    public String getEncoding();

    public void setEncoding(String var1);

    public int write(String var1, String var2) throws IOException, BufferOverflowException;

    public void write(ByteBuffer[] var1, IWriteCompletionHandler var2) throws IOException;

    public void write(ByteBuffer var1, IWriteCompletionHandler var2) throws IOException;

    public void write(List<ByteBuffer> var1, IWriteCompletionHandler var2) throws IOException;

    public void write(ByteBuffer[] var1, int var2, int var3, IWriteCompletionHandler var4) throws IOException;

    public void write(byte[] var1, IWriteCompletionHandler var2) throws IOException;

    public void write(byte[] var1, int var2, int var3, IWriteCompletionHandler var4) throws IOException;

    public void write(String var1, String var2, IWriteCompletionHandler var3) throws IOException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException, SocketTimeoutException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, SocketTimeoutException;

    public byte[] readBytesByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException;

    public byte[] readBytesByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, SocketTimeoutException;

    public String readStringByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException;

    public String readStringByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException;

    public String readStringByLength(int var1, String var2) throws IOException, BufferUnderflowException, UnsupportedEncodingException, SocketTimeoutException;

    @Override
    public long transferFrom(FileChannel var1) throws IOException, BufferOverflowException;

    public int getMaxReadBufferThreshold();

    public void setMaxReadBufferThreshold(int var1);

    public void setFlushmode(IConnection.FlushMode var1);

    public IConnection.FlushMode getFlushmode();
}

