/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoQueue;
import org.xsocket.connection.IoSSLProcessor;

final class IoActivateableSSLHandler
extends IoChainableHandler
implements IoSSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoActivateableSSLHandler.class.getName());
    private AtomicReference<Mode> outboundModeRef = new AtomicReference<Mode>(Mode.PLAIN);
    private AtomicReference<Mode> inboundModeRef = new AtomicReference<Mode>(Mode.PLAIN);
    private IoQueue inNetDataQueue = new IoQueue();
    private IoQueue outNetDataQueue = new IoQueue();
    private IoQueue outAppDataQueue = new IoQueue();
    private final PendingWriteMap pendingWriteMap = new PendingWriteMap();
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private final SSLContext sslContext;
    private final boolean isClientMode;
    private final AbstractMemoryManager memoryManager;
    private final AtomicReference<IoSSLProcessor> sslProcessorRef = new AtomicReference();

    IoActivateableSSLHandler(IoChainableHandler successor, SSLContext sslContext, boolean isClientMode, AbstractMemoryManager memoryManager) throws IOException {
        super(successor);
        this.sslContext = sslContext;
        this.isClientMode = isClientMode;
        this.memoryManager = memoryManager;
    }

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
    }

    @Override
    public boolean isSecure() {
        return this.outboundModeRef.get() == Mode.SSL && this.inboundModeRef.get() == Mode.SSL;
    }

    @Override
    public boolean reset() {
        this.inNetDataQueue.drain();
        this.outNetDataQueue.drain();
        this.outAppDataQueue.drain();
        this.pendingWriteMap.clear();
        return super.reset();
    }

    @Override
    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    @Override
    public void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.hardFlush();
        }
        this.getSuccessor().close(immediate);
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.outAppDataQueue.getSize() + super.getPendingWriteDataSize();
    }

    @Override
    public boolean hasDataToSend() {
        return !this.outAppDataQueue.isEmpty() || super.hasDataToSend();
    }

    @Override
    public void write(ByteBuffer[] buffers) throws ClosedChannelException, IOException {
        this.outAppDataQueue.append(buffers);
    }

    @Override
    public void hardFlush() throws IOException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Mode outboundMode = this.outboundModeRef.get();
        if (outboundMode == Mode.SSL) {
            IoSSLProcessor sslProcessor = this.sslProcessorRef.get();
            IoQueue ioQueue = this.outAppDataQueue;
            synchronized (ioQueue) {
                if (!this.outAppDataQueue.isEmpty()) {
                    sslProcessor.addOutAppData(this.outAppDataQueue.drain());
                }
            }
            sslProcessor.encrypt();
        } else if (outboundMode == Mode.PLAIN) {
            IoQueue ioQueue = this.outAppDataQueue;
            synchronized (ioQueue) {
                if (!this.outAppDataQueue.isEmpty()) {
                    ByteBuffer[] data = this.outAppDataQueue.drain();
                    this.getSuccessor().write(data);
                }
            }
            this.getSuccessor().flush();
        } else assert (outboundMode == Mode.BUFFERING);
    }

    public boolean preActivateSecuredMode() {
        IoSSLProcessor sslProcessor;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] switch to prestart secured mode (interpret incomming as SSL, writing plain outgoing plain)");
        }
        if ((sslProcessor = this.sslProcessorRef.get()) == null) {
            sslProcessor = new IoSSLProcessor(this.sslContext, this.isClientMode, this.memoryManager, this);
            this.sslProcessorRef.set(sslProcessor);
            this.inboundModeRef.set(Mode.SSL);
            return true;
        }
        LOG.warning("connection is already in ssl mode (" + this.printSSLState() + "). Ignore (pre)startSecured Mode");
        return false;
    }

    private String printSSLState() {
        return "inbound: " + (Object)((Object)this.inboundModeRef.get()) + " outbound: " + (Object)((Object)this.outboundModeRef.get());
    }

    public void activateSecuredMode(ByteBuffer[] data) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] switch to secured mode (handle incomming and outgoing as SSL)");
        }
        this.outboundModeRef.set(Mode.BUFFERING);
        if (data != null && data.length > 0) {
            this.inNetDataQueue.addFirst(data);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] start ssl processor");
        }
        IoSSLProcessor sslProcessor = this.sslProcessorRef.get();
        sslProcessor.start();
        this.hardFlush();
        this.readIncomingEncryptedData(this.inNetDataQueue.drain());
    }

    public void deactivateSecuredMode() throws IOException {
        IoSSLProcessor sslProcessor = this.sslProcessorRef.get();
        if (sslProcessor == null) {
            LOG.warning("connection is already in plain mode (" + this.printSSLState() + "). Ignore deactivate");
        } else {
            this.hardFlush();
            this.outboundModeRef.set(Mode.PLAIN);
            this.sslProcessorRef.get().stop();
        }
    }

    @Override
    public void onInboundClosed() throws IOException {
        this.inboundModeRef.set(Mode.PLAIN);
    }

    @Override
    public void onHandshakeFinished() throws IOException {
        this.outboundModeRef.set(Mode.SSL);
        this.hardFlush();
    }

    private void readIncomingEncryptedData(ByteBuffer[] inNetDataList) throws ClosedChannelException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                ByteBuffer[] byteBufferArray = inNetDataList;
                int n = inNetDataList.length;
                int n2 = 0;
                while (n2 < n) {
                    ByteBuffer buffer = byteBufferArray[n2];
                    size += buffer.remaining();
                    ++n2;
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessorRef.get().decrypt(inNetDataList);
        }
    }

    @Override
    public void onDestroy() throws IOException {
        this.close(true);
    }

    @Override
    public void onDataDecrypted(ByteBuffer decryptedBuffer) {
        if (decryptedBuffer == null || !decryptedBuffer.hasRemaining()) {
            return;
        }
        this.getPreviousCallback().onData(new ByteBuffer[]{decryptedBuffer}, decryptedBuffer.remaining());
    }

    @Override
    public void onPostDataDecrypted() {
        this.getPreviousCallback().onPostData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataEncrypted(ByteBuffer plainData, ByteBuffer encryptedData) throws IOException {
        if (encryptedData.hasRemaining()) {
            this.pendingWriteMap.add(plainData, encryptedData);
        }
        IoQueue ioQueue = this.outNetDataQueue;
        synchronized (ioQueue) {
            this.outNetDataQueue.append(encryptedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPostDataEncrypted() throws IOException {
        IoQueue ioQueue = this.outNetDataQueue;
        synchronized (ioQueue) {
            ByteBuffer[] data = this.outNetDataQueue.drain();
            if (LOG.isLoggable(Level.FINE) && data != null) {
                int size = 0;
                ByteBuffer[] byteBufferArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    ByteBuffer buffer = byteBufferArray[n2];
                    size += buffer.remaining();
                    ++n2;
                }
                LOG.fine("sending out app data (" + size + ")");
            }
            this.getSuccessor().write(data);
        }
        this.getSuccessor().flush();
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        @Override
        public void onData(ByteBuffer[] data, int size) {
            block5: {
                try {
                    Mode inboundMode = (Mode)((Object)IoActivateableSSLHandler.this.inboundModeRef.get());
                    if (inboundMode == Mode.PLAIN) {
                        IoActivateableSSLHandler.this.getPreviousCallback().onData(data, size);
                        IoActivateableSSLHandler.this.getPreviousCallback().onPostData();
                        break block5;
                    }
                    if (inboundMode == Mode.SSL) {
                        IoActivateableSSLHandler.this.readIncomingEncryptedData(data);
                        break block5;
                    }
                    assert (inboundMode == Mode.BUFFERING);
                    IoActivateableSSLHandler.this.inNetDataQueue.append(data);
                    return;
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + IoActivateableSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        @Override
        public void onPostData() {
        }

        @Override
        public void onConnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnect();
        }

        @Override
        public void onConnectException(IOException ioe) {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnectException(ioe);
        }

        @Override
        public void onWriteException(IOException ioException, ByteBuffer data) {
            IoActivateableSSLHandler.this.getPreviousCallback().onWriteException(ioException, data);
        }

        @Override
        public void onWritten(ByteBuffer data) {
            ByteBuffer plainData = IoActivateableSSLHandler.this.pendingWriteMap.getPlainIfWritten(data);
            if (plainData != null) {
                IoActivateableSSLHandler.this.getPreviousCallback().onWritten(plainData);
            } else {
                IoActivateableSSLHandler.this.getPreviousCallback().onWritten(data);
            }
        }

        @Override
        public void onDisconnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onDisconnect();
        }

        @Override
        public void onConnectionAbnormalTerminated() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }

    private static enum Mode {
        PLAIN,
        SSL,
        BUFFERING;

    }

    private static final class PendingWriteMap {
        private Map<ByteBuffer, List<ByteBuffer>> plainEncryptedMapping = new IdentityHashMap<ByteBuffer, List<ByteBuffer>>();
        private Map<ByteBuffer, ByteBuffer> encryptedPlainMapping = new IdentityHashMap<ByteBuffer, ByteBuffer>();

        private PendingWriteMap() {
        }

        public synchronized void add(ByteBuffer plain, ByteBuffer encrypted) {
            if (plain.limit() > 0) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                if (encryptedList == null) {
                    encryptedList = new ArrayList<ByteBuffer>();
                    this.plainEncryptedMapping.put(plain, encryptedList);
                }
                encryptedList.add(encrypted);
                this.encryptedPlainMapping.put(encrypted, plain);
            }
        }

        public synchronized ByteBuffer getPlainIfWritten(ByteBuffer encrypted) {
            ByteBuffer plain = this.encryptedPlainMapping.remove(encrypted);
            if (plain != null) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                encryptedList.remove(encrypted);
                if (encryptedList.isEmpty()) {
                    this.plainEncryptedMapping.remove(plain);
                    return plain;
                }
            }
            return null;
        }

        public synchronized void clear() {
            this.plainEncryptedMapping.clear();
            this.encryptedPlainMapping.clear();
        }
    }
}

