/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;

final class IoUnsynchronizedMemoryManager
extends AbstractMemoryManager {
    private static final Logger LOG = Logger.getLogger(IoUnsynchronizedMemoryManager.class.getName());
    private ByteBuffer freeBuffer;

    private IoUnsynchronizedMemoryManager(int preallocationSize, boolean preallocate, int minPreallocatedBufferSize, boolean useDirectMemory) {
        super(preallocationSize, preallocate, minPreallocatedBufferSize, useDirectMemory);
    }

    public static IoUnsynchronizedMemoryManager createPreallocatedMemoryManager(int preallocationSize, int minBufferSze, boolean useDirectMemory) {
        return new IoUnsynchronizedMemoryManager(preallocationSize, true, minBufferSze, useDirectMemory);
    }

    public static IoUnsynchronizedMemoryManager createNonPreallocatedMemoryManager(boolean useDirectMemory) {
        return new IoUnsynchronizedMemoryManager(0, false, 1, useDirectMemory);
    }

    @Override
    public int getCurrentSizePreallocatedBuffer() {
        if (this.freeBuffer != null) {
            return this.freeBuffer.remaining();
        }
        return 0;
    }

    @Override
    public void recycleMemory(ByteBuffer buffer) {
        if (this.isPreallocationMode() && buffer.remaining() >= this.getPreallocatedMinBufferSize()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("recycling " + DataConverter.toFormatedBytesSize(buffer.remaining()));
            }
            this.freeBuffer = buffer;
        }
    }

    @Override
    public ByteBuffer acquireMemoryStandardSizeOrPreallocated(int standardSize) throws IOException {
        if (this.isPreallocationMode()) {
            this.preallocate();
        } else {
            this.freeBuffer = this.newBuffer(standardSize);
        }
        ByteBuffer buffer = this.freeBuffer;
        this.freeBuffer = null;
        return buffer;
    }

    @Override
    public void preallocate() throws IOException {
        if (this.isPreallocationMode()) {
            if (this.freeBuffer != null && this.freeBuffer.remaining() >= this.getPreallocatedMinBufferSize()) {
                return;
            }
            this.freeBuffer = this.newBuffer(this.getPreallocationBufferSize());
        }
    }
}

