/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.IntrospectionBasedDynamicMBean;
import org.xsocket.connection.DispatcherPoolMBeanProxyFactory;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.IoSocketDispatcherPool;
import org.xsocket.connection.Server;

final class ServerMBeanProxyFactory {
    ServerMBeanProxyFactory() {
    }

    public static ObjectName createAndRegister(IServer server, String domain, MBeanServer mbeanServer) throws Exception {
        String address = String.valueOf(server.getLocalAddress().getCanonicalHostName()) + ":" + server.getLocalPort();
        ObjectName serverObjectName = ServerMBeanProxyFactory.registerMBeans(server, domain, address, mbeanServer);
        server.addListener(new Listener(server, domain, address, mbeanServer));
        return serverObjectName;
    }

    private static ObjectName registerMBeans(IServer server, String domain, String address, MBeanServer mbeanServer) throws Exception {
        address = address.replace(":", "_");
        IHandler hdl = server.getHandler();
        ObjectName hdlObjectName = new ObjectName(String.valueOf(domain) + ".server." + address + ":type=" + hdl.getClass().getSimpleName());
        if (hdl instanceof MBeanRegistration) {
            ((MBeanRegistration)((Object)hdl)).preRegister(mbeanServer, hdlObjectName);
        } else {
            mbeanServer.registerMBean(new IntrospectionBasedDynamicMBean(hdl), hdlObjectName);
        }
        ObjectName serverObjectName = null;
        if (server instanceof Server) {
            IoSocketDispatcherPool dispatcherPool = ((Server)server).getAcceptor().getDispatcherPool();
            DispatcherPoolMBeanProxyFactory.createAndRegister(dispatcherPool, String.valueOf(domain) + ".server." + address, mbeanServer);
        }
        serverObjectName = new ObjectName(String.valueOf(domain) + ".server." + address + ":type=xServer,name=" + server.hashCode());
        mbeanServer.registerMBean(new IntrospectionBasedDynamicMBean(server), serverObjectName);
        ObjectName workerpoolObjectName = new ObjectName(String.valueOf(domain) + ".server." + address + ":type=Workerpool");
        mbeanServer.registerMBean(new IntrospectionBasedDynamicMBean(server.getWorkerpool()), workerpoolObjectName);
        if (hdl instanceof MBeanRegistration) {
            ((MBeanRegistration)((Object)hdl)).postRegister(true);
        }
        return serverObjectName;
    }

    private static void unregisterMBeans(IServer server, String domain, String address, MBeanServer mbeanServer) throws Exception {
        address = address.replace(":", "_");
        IHandler hdl = server.getHandler();
        ObjectName hdlObjectName = new ObjectName(String.valueOf(domain) + ".server." + address + ":type=" + server.getHandler().getClass().getSimpleName());
        if (hdl instanceof MBeanRegistration) {
            ((MBeanRegistration)((Object)hdl)).preDeregister();
        }
        mbeanServer.unregisterMBean(hdlObjectName);
        ObjectName workerpoolObjectName = new ObjectName(String.valueOf(domain) + ".server." + address + ":type=Workerpool");
        mbeanServer.unregisterMBean(workerpoolObjectName);
        if (hdl instanceof MBeanRegistration) {
            ((MBeanRegistration)((Object)hdl)).postDeregister();
        }
    }

    private static final class Listener
    implements IServerListener {
        private static final Logger LOG = Logger.getLogger(Listener.class.getName());
        private final IServer server;
        private final String domain;
        private final String address;
        private final MBeanServer mbeanServer;

        Listener(IServer server, String domain, String address, MBeanServer mbeanServer) {
            this.server = server;
            this.domain = domain;
            this.address = address;
            this.mbeanServer = mbeanServer;
            server.addListener(this);
        }

        @Override
        public void onInit() {
        }

        @Override
        public void onDestroy() {
            try {
                ServerMBeanProxyFactory.unregisterMBeans(this.server, this.domain, this.address, this.mbeanServer);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by deregistering the server (domain=" + this.domain + "). reason: " + e.toString());
                }
                throw new RuntimeException(e);
            }
        }
    }
}

