/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.ConnectionUtils;

final class WriteQueue
implements Cloneable {
    private final Queue queue = new Queue();
    private RewriteableBuffer writeMarkBuffer = null;
    private boolean isWriteMarked = false;

    WriteQueue() {
    }

    public void reset() {
        this.queue.reset();
        this.writeMarkBuffer = null;
        this.isWriteMarked = false;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty() && this.writeMarkBuffer == null;
    }

    public int getSize() {
        int size = this.queue.getSize();
        if (this.writeMarkBuffer != null) {
            size += this.writeMarkBuffer.size();
        }
        return size;
    }

    public ByteBuffer[] drain() {
        return this.queue.drain();
    }

    public void append(ByteBuffer data) {
        if (data == null) {
            return;
        }
        if (this.isWriteMarked) {
            this.writeMarkBuffer.append(data);
        } else {
            this.queue.append(data);
        }
    }

    public void append(ByteBuffer[] bufs) {
        if (bufs == null) {
            return;
        }
        if (bufs.length < 1) {
            return;
        }
        if (this.isWriteMarked) {
            ByteBuffer[] byteBufferArray = bufs;
            int n = bufs.length;
            int n2 = 0;
            while (n2 < n) {
                ByteBuffer buffer = byteBufferArray[n2];
                this.writeMarkBuffer.append(buffer);
                ++n2;
            }
        } else {
            this.queue.append(bufs);
        }
    }

    public void markWritePosition() {
        this.removeWriteMark();
        this.isWriteMarked = true;
        this.writeMarkBuffer = new RewriteableBuffer();
    }

    public void removeWriteMark() {
        if (this.isWriteMarked) {
            this.isWriteMarked = false;
            this.append(this.writeMarkBuffer.drain());
            this.writeMarkBuffer = null;
        }
    }

    public boolean resetToWriteMark() {
        if (this.isWriteMarked) {
            this.writeMarkBuffer.resetWritePosition();
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        WriteQueue copy = new WriteQueue();
        copy.queue.append(this.queue.copy());
        if (this.writeMarkBuffer != null) {
            copy.writeMarkBuffer = (RewriteableBuffer)this.writeMarkBuffer.clone();
        }
        return copy;
    }

    public String toString(String encoding) {
        return this.queue.toString(encoding);
    }

    public String toString() {
        return this.queue.toString();
    }

    private static final class Queue
    implements AbstractNonBlockingStream.ISink {
        private ByteBuffer[] buffers;

        private Queue() {
        }

        @Override
        public synchronized void reset() {
            this.buffers = null;
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.empty();
        }

        private boolean empty() {
            return this.buffers == null;
        }

        @Override
        public synchronized int getSize() {
            if (this.empty()) {
                return 0;
            }
            int size = 0;
            if (this.buffers != null) {
                int i = 0;
                while (i < this.buffers.length) {
                    if (this.buffers[i] != null) {
                        size += this.buffers[i].remaining();
                    }
                    ++i;
                }
            }
            return size;
        }

        @Override
        public synchronized void append(ByteBuffer data) {
            if (this.buffers == null) {
                this.buffers = new ByteBuffer[1];
                this.buffers[0] = data;
            } else {
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + 1];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                newBuffers[this.buffers.length] = data;
                this.buffers = newBuffers;
            }
        }

        @Override
        public synchronized void append(ByteBuffer[] bufs) {
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + bufs.length];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                System.arraycopy(bufs, 0, newBuffers, this.buffers.length, bufs.length);
                this.buffers = newBuffers;
            }
        }

        @Override
        public synchronized ByteBuffer[] drain() {
            ByteBuffer[] result = this.buffers;
            this.buffers = null;
            return result;
        }

        @Override
        public synchronized ByteBuffer[] copy() {
            return ConnectionUtils.copy(this.buffers);
        }

        public String toString() {
            return this.toString("US-ASCII");
        }

        @Override
        public synchronized String toString(String encoding) {
            StringBuilder sb = new StringBuilder();
            if (this.buffers != null) {
                ByteBuffer[] copy = new ByteBuffer[this.buffers.length];
                try {
                    int i = 0;
                    while (i < copy.length) {
                        if (this.buffers[i] != null) {
                            copy[i] = this.buffers[i].duplicate();
                        }
                        ++i;
                    }
                    sb.append(DataConverter.toString(copy, encoding, Integer.MAX_VALUE));
                }
                catch (UnsupportedEncodingException use) {
                    sb.append(DataConverter.toHexString(copy, Integer.MAX_VALUE));
                }
            }
            return sb.toString();
        }
    }

    private static final class RewriteableBuffer
    implements Cloneable {
        private ArrayList<ByteBuffer> bufs = new ArrayList();
        private int writePosition = 0;

        private RewriteableBuffer() {
        }

        public void append(ByteBuffer buffer) {
            if (buffer.remaining() < 1) {
                return;
            }
            if (this.writePosition == this.bufs.size()) {
                this.bufs.add(buffer);
                ++this.writePosition;
            } else {
                ByteBuffer currentBuffer = this.bufs.remove(this.writePosition);
                if (currentBuffer.remaining() == buffer.remaining()) {
                    this.bufs.add(this.writePosition, buffer);
                    ++this.writePosition;
                } else if (currentBuffer.remaining() > buffer.remaining()) {
                    currentBuffer.position(currentBuffer.position() + buffer.remaining());
                    this.bufs.add(this.writePosition, currentBuffer);
                    this.bufs.add(this.writePosition, buffer);
                    ++this.writePosition;
                } else {
                    this.bufs.add(this.writePosition, buffer);
                    ++this.writePosition;
                    int bytesToRemove = buffer.remaining() - currentBuffer.remaining();
                    while (bytesToRemove > 0) {
                        if (this.writePosition < this.bufs.size()) {
                            ByteBuffer buf = this.bufs.remove(this.writePosition);
                            if (buf.remaining() > bytesToRemove) {
                                buf.position(buf.position() + bytesToRemove);
                                this.bufs.add(this.writePosition, buf);
                                continue;
                            }
                            bytesToRemove -= buf.remaining();
                            continue;
                        }
                        bytesToRemove = 0;
                    }
                }
            }
        }

        public void resetWritePosition() {
            this.writePosition = 0;
        }

        public ByteBuffer[] drain() {
            ByteBuffer[] result = this.bufs.toArray(new ByteBuffer[this.bufs.size()]);
            this.bufs.clear();
            this.writePosition = 0;
            return result;
        }

        public int size() {
            int size = 0;
            for (ByteBuffer buffer : this.bufs) {
                size += buffer.remaining();
            }
            return size;
        }

        protected Object clone() throws CloneNotSupportedException {
            RewriteableBuffer copy = (RewriteableBuffer)super.clone();
            copy.bufs = new ArrayList();
            for (ByteBuffer buffer : this.bufs) {
                copy.bufs.add(buffer.duplicate());
            }
            return copy;
        }
    }
}

