/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.datagram.AbstractEndpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.IoSocketDispatcher;
import org.xsocket.datagram.MemoryManager;
import org.xsocket.datagram.UserDatagram;

abstract class AbstractChannelBasedEndpoint
extends AbstractEndpoint {
    private static final Logger LOG = Logger.getLogger(AbstractChannelBasedEndpoint.class.getName());
    private static final MemoryManager memoryManager = new MemoryManager(65536, false);
    private static IoSocketDispatcher dispatcher = AbstractChannelBasedEndpoint.createDispatcher();
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private final DatagramSocket socket;
    private final DatagramChannel channel;
    private final ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private final List<UserDatagram> sendQueue = Collections.synchronizedList(new LinkedList());

    static {
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_RCVBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_SNDBUF", Integer.class);
        SUPPORTED_OPTIONS.put("IPPROTO_IP.IP_TOS", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
    }

    AbstractChannelBasedEndpoint(InetSocketAddress addr, Map<String, Object> options, IDatagramHandler datagramHandler, int receivePacketSize, Executor workerPool) throws IOException {
        super(datagramHandler, receivePacketSize, workerPool);
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.socket = this.channel.socket();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            this.setOption(entry.getKey(), entry.getValue());
        }
        this.socket.bind(addr);
        dispatcher.register(this);
        this.logFine("enpoint has been bound to locale port " + this.getLocalPort() + " (server mode)");
    }

    private static IoSocketDispatcher createDispatcher() {
        IoSocketDispatcher disp = new IoSocketDispatcher();
        Thread t = new Thread(disp);
        t.setName("DispatcherThread#" + disp.hashCode());
        t.setDaemon(true);
        t.start();
        return disp;
    }

    protected final DatagramChannel getChannel() {
        return this.channel;
    }

    @Override
    public final void close() {
        if (this.isOpen()) {
            try {
                this.logFine("closing " + this.toCompactString());
                this.channel.close();
            }
            catch (IOException ioe) {
                this.logFine("error occured by closing connection. Reason " + ioe.toString());
            }
            super.close();
        }
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    private void logFine(String msg) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] " + msg);
        }
    }

    @Override
    public void send(UserDatagram packet) throws IOException {
        if (packet.getRemoteAddress() == null) {
            throw new IOException("remote socket adress has to be set");
        }
        this.logFine("add datagram packet (" + packet + ") to write queue");
        packet.prepareForSend();
        this.sendQueue.add(packet);
        this.logFine("update interest ops to write");
        dispatcher.initiateWrite(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePhysical() {
        if (!this.sendQueue.isEmpty()) {
            List<UserDatagram> list = this.sendQueue;
            synchronized (list) {
                for (UserDatagram packet : this.sendQueue) {
                    try {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] sending datagram " + packet.toString());
                        }
                        int dataToSend = packet.getSize();
                        int written = this.channel.send(packet.getData(), packet.getRemoteSocketAddress());
                        if (!LOG.isLoggable(Level.FINE) || dataToSend == written) continue;
                        LOG.fine("Error occured by sending datagram. Size DataToSend=" + dataToSend + ", written=" + written);
                    }
                    catch (IOException ioe) {
                        LOG.warning("could not write datagram to " + packet.getRemoteAddress() + " .Reason: " + DataConverter.toString(ioe));
                    }
                }
                this.sendQueue.clear();
            }
        }
    }

    public String toCompactString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.socket.getLocalAddress().getCanonicalHostName() + ":" + this.getLocalPort();
    }

    final void onReadableEvent() {
        if (this.isOpen()) {
            try {
                if (this.getReceiveSize() > 0) {
                    ByteBuffer readBuffer = memoryManager.acquireMemory(this.getReceiveSize());
                    readBuffer.order(this.byteOrder);
                    SocketAddress address = this.channel.receive(readBuffer);
                    if (address == null) {
                        return;
                    }
                    if (readBuffer.position() == 0) {
                        return;
                    }
                    readBuffer.flip();
                    this.onData(address, readBuffer);
                }
            }
            catch (IOException ioe) {
                this.logFine("error occured while receiving. Reason: " + ioe.toString());
            }
        }
    }

    final void onWriteableEvent() throws IOException {
        dispatcher.setSelectionKeyToReadImmediately(this);
        this.writePhysical();
    }

    final void onDispatcherClose() {
        this.close();
    }

    protected AbstractChannelBasedEndpoint setOption(String name, Object value) throws IOException {
        if (name.equals("SOL_SOCKET.SO_SNDBUF")) {
            this.socket.setSendBufferSize((Integer)value);
        } else if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            this.socket.setReuseAddress((Boolean)value);
        } else if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            this.socket.setReceiveBufferSize((Integer)value);
        } else if (name.equals("IPPROTO_IP.IP_TOS")) {
            this.socket.setTrafficClass((Integer)value);
        } else {
            LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        }
        return this;
    }

    @Override
    public Object getOption(String name) throws IOException {
        if (name.equals("SOL_SOCKET.SO_SNDBUF")) {
            return this.socket.getSendBufferSize();
        }
        if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            return this.socket.getReuseAddress();
        }
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            return this.socket.getReceiveBufferSize();
        }
        if (name.equals("IPPROTO_IP.IP_TOS")) {
            return this.socket.getTrafficClass();
        }
        LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        return null;
    }

    @Override
    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }
}

