/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.IEndpoint;
import org.xsocket.datagram.UserDatagram;

abstract class AbstractEndpoint
implements IEndpoint {
    private static final Logger LOG = Logger.getLogger(AbstractEndpoint.class.getName());
    private static Executor GLOBAL_WORKERPOOL = Executors.newCachedThreadPool();
    private static String idPrefix;
    private static long nextId;
    private final String id;
    private String defaultEncoding = "UTF-8";
    private final Object readGuard = new Object();
    private final ReceiveQueue receiveQueue = new ReceiveQueue();
    private int receiveSize = -1;
    private final IDatagramHandler datagramHandler;
    private Executor workerPool;
    private long openTime = -1L;
    private long lastTimeReceived = System.currentTimeMillis();
    private long receivedBytes = 0L;

    static {
        nextId = 0L;
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = "locale";
        }
        int random = 0;
        Random rand = new Random();
        while ((random = rand.nextInt()) < 0) {
        }
        idPrefix = String.valueOf(Integer.toHexString(base.hashCode())) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
    }

    AbstractEndpoint(IDatagramHandler datagramHandler, int receiveSize, Executor workerPool) {
        this.datagramHandler = datagramHandler;
        this.receiveSize = receiveSize;
        this.workerPool = workerPool;
        this.id = String.valueOf(idPrefix) + "." + ++nextId;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractEndpoint.this.close();
            }
        });
        this.openTime = System.currentTimeMillis();
    }

    protected static Executor getGlobalWorkerPool() {
        return GLOBAL_WORKERPOOL;
    }

    @Override
    public void close() {
    }

    public Executor getWorkerpool() {
        return this.workerPool;
    }

    @Override
    public final void setReceiveSize(int receivePacketSize) {
        this.receiveSize = receivePacketSize;
    }

    @Override
    public final int getReceiveSize() {
        return this.receiveSize;
    }

    protected final void onData(SocketAddress address, ByteBuffer data) {
        UserDatagram packet = new UserDatagram(address, data, this.getDefaultEncoding());
        this.receiveQueue.offer(packet);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] datagram received: " + packet.toString());
        }
        this.lastTimeReceived = System.currentTimeMillis();
        this.receivedBytes += (long)data.remaining();
        if (this.datagramHandler != null) {
            this.workerPool.execute(new HandlerProcessor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UserDatagram receive(long timeoutMillis) throws IOException, SocketTimeoutException {
        UserDatagram datagram = null;
        if (this.getReceiveSize() <= 0) {
            throw new IOException("the receive packet size has not been set");
        }
        if (timeoutMillis <= 0L) {
            datagram = this.receive();
        } else {
            long start = System.currentTimeMillis();
            Object object = this.readGuard;
            synchronized (object) {
                while ((datagram = this.receive()) == null) {
                    try {
                        this.readGuard.wait(timeoutMillis / 10L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    if (System.currentTimeMillis() < start + timeoutMillis) continue;
                }
            }
        }
        if (datagram == null) {
            throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(timeoutMillis) + " reached");
        }
        return datagram;
    }

    @Override
    public UserDatagram receive() {
        return this.receiveQueue.poll();
    }

    @Override
    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    public String toString() {
        return " received=" + DataConverter.toFormatedBytesSize(this.receivedBytes) + ", age=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.openTime) + ", lastReceived=" + DataConverter.toFormatedDate(this.lastTimeReceived) + " [" + this.id + "]";
    }

    private final class HandlerProcessor
    implements Runnable {
        private HandlerProcessor() {
        }

        @Override
        public void run() {
            try {
                if (!AbstractEndpoint.this.receiveQueue.isEmpty()) {
                    AbstractEndpoint.this.datagramHandler.onDatagram(AbstractEndpoint.this);
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by performing onData task. Reason: " + e.toString());
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static final class ReceiveQueue {
        private List<UserDatagram> receiveQueue = new ArrayList<UserDatagram>();
        private int modifyVersion = 0;

        private ReceiveQueue() {
        }

        public synchronized void offer(UserDatagram userDatagram) {
            ++this.modifyVersion;
            this.receiveQueue.add(userDatagram);
        }

        public synchronized UserDatagram poll() {
            if (this.receiveQueue.isEmpty()) {
                return null;
            }
            ++this.modifyVersion;
            return this.receiveQueue.remove(0);
        }

        public synchronized boolean isEmpty() {
            ++this.modifyVersion;
            return this.receiveQueue.isEmpty();
        }

        public String toString() {
            return String.valueOf(this.receiveQueue.size()) + " (modifyVersion=" + this.modifyVersion + ")";
        }
    }
}

